/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ByteStringComparatorTest {
    @Test
    public void emptyTest() {
        int result = ByteStringComparator.INSTANCE.compare(ByteString.EMPTY, ByteString.EMPTY);
        Truth.assertThat((Integer)result).isEqualTo((Object)0);
    }

    @Test
    public void equalTest() {
        int result = ByteStringComparator.INSTANCE.compare(ByteString.copyFromUtf8((String)"a"), ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Integer)result).isEqualTo((Object)0);
    }

    @Test
    public void unequalTest() {
        ByteString a = ByteString.copyFromUtf8((String)"a");
        ByteString b = ByteString.copyFromUtf8((String)"b");
        Truth.assertThat((Integer)ByteStringComparator.INSTANCE.compare(a, b)).isEqualTo((Object)"a".compareTo("b"));
        Truth.assertThat((Integer)ByteStringComparator.INSTANCE.compare(b, a)).isEqualTo((Object)"b".compareTo("a"));
    }

    @Test
    public void lengthTest() {
        ByteString a = ByteString.copyFromUtf8((String)"a");
        ByteString a_ = ByteString.copyFromUtf8((String)"b").concat(ByteString.copyFrom((byte[])new byte[]{0}));
        Truth.assertThat((Integer)ByteStringComparator.INSTANCE.compare(a, a_)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)ByteStringComparator.INSTANCE.compare(a_, a)).isEqualTo((Object)1);
    }
}

