/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.internal;

import com.google.cloud.bigtable.data.v2.internal.RegexUtil;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RegexUtilTest {
    @Test
    public void literalRegexPassthroughTest() {
        ByteString input = ByteString.copyFromUtf8((String)"hi");
        ByteString actual = RegexUtil.literalRegex((ByteString)input);
        Truth.assertThat((Iterable)actual).isEqualTo((Object)input);
    }

    @Test
    public void literalRegexEscapeTest() {
        ByteString input = ByteString.copyFromUtf8((String)"h.*i");
        ByteString actual = RegexUtil.literalRegex((ByteString)input);
        ByteString expected = ByteString.copyFromUtf8((String)"h\\.\\*i");
        Truth.assertThat((Iterable)actual).isEqualTo((Object)expected);
    }

    @Test
    public void literalRegexEscapeBytes() {
        ByteString input = ByteString.copyFrom((byte[])new byte[]{-30, -128, -77});
        ByteString actual = RegexUtil.literalRegex((ByteString)input);
        Truth.assertThat((Iterable)actual).isEqualTo((Object)input);
    }
}

