/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.client.util.Lists;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.protobuf.util.Timestamps;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BuiltinMetricsIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();
    public static MetricServiceClient metricClient;
    public static String[] VIEWS;

    @BeforeClass
    public static void setUpClass() throws IOException {
        TruthJUnit.assume().withMessage("Builtin metrics integration test is not supported by emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BigtableDataSettings.enableBuiltinMetrics();
        metricClient = MetricServiceClient.create();
    }

    @AfterClass
    public static void tearDown() {
        if (metricClient != null) {
            metricClient.close();
        }
    }

    @Test
    public void testBuiltinMetrics() throws Exception {
        testEnvRule.env().getDataClient().mutateRow(RowMutation.create((String)testEnvRule.env().getTableId(), (String)"a-new-key").setCell(testEnvRule.env().getFamilyId(), "q", "abc"));
        ArrayList rows = Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(Query.create((String)testEnvRule.env().getTableId()).limit(10L)));
        Thread.sleep(Duration.ofMinutes(5L).toMillis());
        ProjectName name = ProjectName.of((String)testEnvRule.env().getProjectId());
        long startMillis = System.currentTimeMillis() - Duration.ofMinutes(10L).toMillis();
        TimeInterval interval = TimeInterval.newBuilder().setStartTime(Timestamps.fromMillis((long)startMillis)).setEndTime(Timestamps.fromMillis((long)System.currentTimeMillis())).build();
        for (String view : VIEWS) {
            String metricFilter = String.format("metric.type=\"bigtable.googleapis.com/client/%s\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Bigtable.MutateRow\"", view, testEnvRule.env().getInstanceId());
            ListTimeSeriesRequest.Builder requestBuilder = ListTimeSeriesRequest.newBuilder().setName(name.toString()).setFilter(metricFilter).setInterval(interval).setView(ListTimeSeriesRequest.TimeSeriesView.FULL);
            ListTimeSeriesResponse response = (ListTimeSeriesResponse)metricClient.listTimeSeriesCallable().call((Object)requestBuilder.build());
            Truth.assertThat((Integer)response.getTimeSeriesCount()).isGreaterThan((Comparable)Integer.valueOf(0));
            metricFilter = String.format("metric.type=\"bigtable.googleapis.com/client/operation_latencies\" AND resource.labels.instance=\"%s\" AND metric.labels.method=\"Bigtable.ReadRows\"", testEnvRule.env().getInstanceId());
            requestBuilder.setFilter(metricFilter);
            response = (ListTimeSeriesResponse)metricClient.listTimeSeriesCallable().call((Object)requestBuilder.build());
            Truth.assertThat((Integer)response.getTimeSeriesCount()).isGreaterThan((Comparable)Integer.valueOf(0));
        }
    }

    static {
        VIEWS = new String[]{"operation_latencies", "retry_count", "attempt_latencies", "connectivity_error_count", "application_latencies"};
    }
}

