/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.FlowControlEventStats;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BulkMutateIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test(timeout=60000L)
    public void test() throws IOException, InterruptedException {
        BigtableDataSettings settings = testEnvRule.env().getDataClientSettings();
        String rowPrefix = UUID.randomUUID().toString();
        BigtableDataSettings.Builder builder = settings.toBuilder().enableBatchMutationLatencyBasedThrottling(2L);
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)builder.build());
             BatcherImpl batcher = (BatcherImpl)client.newBulkMutationBatcher(testEnvRule.env().getTableId());){
            FlowControlEventStats events = batcher.getFlowController().getFlowControlEventStats();
            long initialThreashold = Objects.requireNonNull(batcher.getFlowController().getCurrentElementCountLimit());
            Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isNotEqualTo((Object)batcher.getFlowController().getMinElementCountLimit());
            Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isNotEqualTo((Object)batcher.getFlowController().getMaxElementCountLimit());
            String familyId = testEnvRule.env().getFamilyId();
            long initial = batcher.getFlowController().getCurrentElementCountLimit();
            for (long i = 0L; i < initial * 3L; ++i) {
                String key = rowPrefix + "test-key" + i;
                batcher.add((Object)RowMutationEntry.create((String)key).setCell(familyId, "qualifier", i));
            }
            batcher.flush();
            Truth.assertThat((Comparable)events.getLastFlowControlEvent()).isNotNull();
            Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isNotEqualTo((Object)initialThreashold);
            Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowPrefix + "test-key" + initial));
            Truth.assertThat((Iterable)row.getCells()).hasSize(1);
        }
    }
}

