/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CheckAndMutateIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws Exception {
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String rowKey = UUID.randomUUID().toString();
        testEnvRule.env().getDataClient().mutateRowCallable().call((Object)RowMutation.create((String)tableId, (String)rowKey).setCell(familyId, "q1", "val1").setCell(familyId, "q2", "val2"));
        testEnvRule.env().getDataClient().checkAndMutateRowAsync(ConditionalRowMutation.create((String)tableId, (String)rowKey).condition(Filters.FILTERS.qualifier().exactMatch("q1")).then(Mutation.create().setCell(familyId, "q3", "q1"))).get(1L, TimeUnit.MINUTES);
        Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)tableId).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"q1"));
    }
}

