/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutateRowIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws Exception {
        String rowKey = UUID.randomUUID().toString();
        String familyId = testEnvRule.env().getFamilyId();
        testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)rowKey).setCell(familyId, "q", "myVal").setCell(familyId, "q2", "myVal2").setCell(familyId, "q3", "myVal3").setCell(familyId, "q4", 305419896L)).get(1L, TimeUnit.MINUTES);
        testEnvRule.env().getDataClient().mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)rowKey).deleteCells(familyId, "q2")).get(1L, TimeUnit.MINUTES);
        Row row = (Row)testEnvRule.env().getDataClient().readRowsCallable().first().call((Object)Query.create((String)testEnvRule.env().getTableId()).rowKey(rowKey));
        Truth.assertThat((Iterable)row.getCells()).hasSize(3);
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(0)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"myVal"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(1)).getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"myVal3"));
        Truth.assertThat((Iterable)((RowCell)row.getCells().get(2)).getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])new byte[]{0, 0, 0, 0, 18, 52, 86, 120}));
    }
}

