/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadIT {
    private String prefix;
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Before
    public void setUp() {
        this.prefix = UUID.randomUUID().toString();
    }

    @Test
    public void isRowExists() throws Exception {
        String rowKey = this.prefix + "-test-row-key";
        String tableId = testEnvRule.env().getTableId();
        testEnvRule.env().getDataClient().mutateRow(RowMutation.create((String)tableId, (String)rowKey).setCell(testEnvRule.env().getFamilyId(), "qualifier", "value"));
        Truth.assertThat((Boolean)testEnvRule.env().getDataClient().exists(tableId, rowKey)).isTrue();
        String nonExistingKey = this.prefix + "non-existing-key";
        Truth.assertThat((Boolean)testEnvRule.env().getDataClient().exists(tableId, nonExistingKey)).isFalse();
        Truth.assertThat((Boolean)((Boolean)testEnvRule.env().getDataClient().existsAsync(tableId, rowKey).get())).isTrue();
    }

    @Test
    public void readEmpty() throws Throwable {
        String uniqueKey = this.prefix + "-readEmpty";
        Query query = Query.create((String)testEnvRule.env().getTableId()).rowKey(uniqueKey);
        ArrayList rows = Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(query));
        Truth.assertThat((Iterable)rows).isEmpty();
        AccumulatingObserver observer = new AccumulatingObserver();
        testEnvRule.env().getDataClient().readRowsAsync(query, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).isEmpty();
    }

    @Test
    public void read() throws Throwable {
        int numRows = 5;
        ArrayList expectedRows = Lists.newArrayList();
        String uniqueKey = this.prefix + "-read";
        long timestampMicros = System.currentTimeMillis() * 1000L;
        for (int i = 0; i < numRows; ++i) {
            testEnvRule.env().getDataClient().mutateRowCallable().call((Object)RowMutation.create((String)testEnvRule.env().getTableId(), (String)(uniqueKey + "-" + i)).setCell(testEnvRule.env().getFamilyId(), "q", timestampMicros, "my-value"));
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(uniqueKey + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)"q"), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"my-value")))));
        }
        String tableId = testEnvRule.env().getTableId();
        Query query = Query.create((String)tableId).range(uniqueKey + "-0", uniqueKey + "-" + numRows);
        ArrayList actualResults = Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(query));
        Truth.assertThat((Iterable)actualResults).containsExactlyElementsIn((Iterable)expectedRows);
        AccumulatingObserver observer = new AccumulatingObserver();
        testEnvRule.env().getDataClient().readRowsAsync(query, (ResponseObserver)observer);
        observer.awaitCompletion();
        Truth.assertThat(observer.responses).containsExactlyElementsIn((Iterable)expectedRows);
        Row actualRow = testEnvRule.env().getDataClient().readRow(tableId, ((Row)expectedRows.get(0)).getKey());
        Truth.assertThat((Object)actualRow).isEqualTo(expectedRows.get(0));
        ApiFuture actualRowFuture = testEnvRule.env().getDataClient().readRowAsync(tableId, ((Row)expectedRows.get(0)).getKey());
        Truth.assertThat((Object)actualRowFuture.get()).isEqualTo(expectedRows.get(0));
    }

    @Test
    public void rangeQueries() {
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String familyId = testEnvRule.env().getFamilyId();
        String uniqueKey = this.prefix + "-range-queries";
        String keyA = uniqueKey + "-a";
        String keyZ = uniqueKey + "-z";
        long timestampMicros = System.currentTimeMillis() * 1000L;
        client.bulkMutateRows(BulkMutation.create((String)tableId).add(RowMutationEntry.create((String)keyA).setCell(familyId, "", timestampMicros, "A")).add(RowMutationEntry.create((String)keyZ).setCell(familyId, "", timestampMicros, "Z")));
        Row expectedRowA = Row.create((ByteString)ByteString.copyFromUtf8((String)keyA), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"A"))));
        Row expectedRowZ = Row.create((ByteString)ByteString.copyFromUtf8((String)keyZ), (List)ImmutableList.of((Object)RowCell.create((String)testEnvRule.env().getFamilyId(), (ByteString)ByteString.copyFromUtf8((String)""), (long)timestampMicros, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"Z"))));
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed(keyA)).endOpen(keyZ))))).containsExactly(new Object[]{expectedRowA});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed(keyA)).endClosed(keyZ))))).containsExactly(new Object[]{expectedRowA, expectedRowZ});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen(keyA)).endClosed(keyZ))))).containsExactly(new Object[]{expectedRowZ});
        Truth.assertThat((Iterable)ImmutableList.copyOf((Iterable)client.readRows(Query.create((String)tableId).range((Range.ByteStringRange)((Range.ByteStringRange)Range.ByteStringRange.unbounded().startOpen(keyA)).endOpen(keyZ))))).isEmpty();
    }

    @Test
    public void readSingleNonexistentAsyncCallback() throws Exception {
        ApiFuture future = testEnvRule.env().getDataClient().readRowAsync(testEnvRule.env().getTableId(), "somenonexistentkey");
        final AtomicReference unexpectedError = new AtomicReference();
        final AtomicBoolean found = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new ApiFutureCallback<Row>(){

            public void onFailure(Throwable t) {
                unexpectedError.set(t);
                latch.countDown();
            }

            public void onSuccess(Row result) {
                found.set(true);
                latch.countDown();
            }
        }, (Executor)MoreExecutors.directExecutor());
        latch.await(1L, TimeUnit.MINUTES);
        if (unexpectedError.get() != null) {
            throw new RuntimeException("Unexpected async error", (Throwable)unexpectedError.get());
        }
        Truth.assertThat((Boolean)found.get()).isTrue();
    }

    static class AccumulatingObserver
    implements ResponseObserver<Row> {
        final List<Row> responses = Lists.newArrayList();
        final SettableApiFuture<Void> completionFuture = SettableApiFuture.create();

        AccumulatingObserver() {
        }

        void awaitCompletion() throws Throwable {
            try {
                this.completionFuture.get(10L, TimeUnit.MINUTES);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }

        public void onStart(StreamController controller) {
        }

        public void onResponse(Row row) {
            this.responses.add(row);
        }

        public void onError(Throwable t) {
            this.completionFuture.setException(t);
        }

        public void onComplete() {
            this.completionFuture.set(null);
        }
    }
}

