/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMutationEntryBatcherIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void testNewBatcher() throws Exception {
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String tableId = testEnvRule.env().getTableId();
        String family = testEnvRule.env().getFamilyId();
        String rowPrefix = UUID.randomUUID().toString();
        try (Batcher batcher = client.newBulkMutationBatcher(tableId);){
            for (int i = 0; i < 10; ++i) {
                batcher.add((Object)RowMutationEntry.create((String)(rowPrefix + "-" + i)).setCell(family, "qualifier", 10000L, "value-" + i));
            }
        }
        ArrayList<Row> expectedRows = new ArrayList<Row>();
        for (int i = 0; i < 10; ++i) {
            expectedRows.add(Row.create((ByteString)ByteString.copyFromUtf8((String)(rowPrefix + "-" + i)), (List)ImmutableList.of((Object)RowCell.create((String)family, (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)10000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)("value-" + i))))));
        }
        ServerStream actualRows = client.readRows(Query.create((String)tableId).prefix(rowPrefix));
        Truth.assertThat((Iterable)actualRows).containsExactlyElementsIn(expectedRows);
    }
}

