/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SampleRowsIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @Test
    public void test() throws InterruptedException, ExecutionException, TimeoutException {
        BigtableDataClient client = testEnvRule.env().getDataClient();
        String rowPrefix = UUID.randomUUID().toString();
        ArrayList futures = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            ApiFuture future = client.mutateRowAsync(RowMutation.create((String)testEnvRule.env().getTableId(), (String)(rowPrefix + "-" + i)).setCell(testEnvRule.env().getFamilyId(), "", "value"));
            futures.add(future);
        }
        ApiFutures.allAsList((Iterable)futures).get(1L, TimeUnit.MINUTES);
        ApiFuture future = client.sampleRowKeysAsync(testEnvRule.env().getTableId());
        List results = (List)future.get(1L, TimeUnit.MINUTES);
        Truth.assertThat((Iterable)results).isNotEmpty();
        Truth.assertThat((Long)((KeyOffset)results.get(results.size() - 1)).getOffsetBytes()).isGreaterThan((Comparable)Long.valueOf(0L));
    }
}

