/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.it;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.stats.BuiltinViews;
import com.google.cloud.bigtable.stats.StatsWrapper;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class StreamingMetricsMetadataIT {
    @ClassRule
    public static TestEnvRule testEnvRule = new TestEnvRule();

    @BeforeClass
    public static void setUpClass() {
        TruthJUnit.assume().withMessage("StreamingMetricsMetadataIT is not supported on Emulator").that((Object)testEnvRule.env()).isNotInstanceOf(EmulatorEnv.class);
        BuiltinViews.registerBigtableBuiltinViews();
    }

    @Test
    public void testSuccess() throws Exception {
        String prefix = UUID.randomUUID().toString();
        String uniqueKey = prefix + "-read";
        Query query = Query.create((String)testEnvRule.env().getTableId()).rowKey(uniqueKey);
        ArrayList rows = Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(query));
        ApiFuture clustersFuture = testEnvRule.env().getInstanceAdminClient().listClustersAsync(testEnvRule.env().getInstanceId());
        List clusters = (List)clustersFuture.get(1L, TimeUnit.MINUTES);
        Thread.sleep(100L);
        List tagValueStrings = StatsWrapper.getOperationLatencyViewTagValueStrings();
        Truth.assertThat((Iterable)tagValueStrings).contains((Object)((Cluster)clusters.get(0)).getZone());
        Truth.assertThat((Iterable)tagValueStrings).contains((Object)((Cluster)clusters.get(0)).getId());
    }

    @Test
    public void testFailure() throws InterruptedException {
        Query query = Query.create((String)"non-exist-table");
        try {
            Lists.newArrayList((Iterable)testEnvRule.env().getDataClient().readRows(query));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        Thread.sleep(100L);
        List tagValueStrings = StatsWrapper.getOperationLatencyViewTagValueStrings();
        Truth.assertThat((Iterable)tagValueStrings).contains((Object)"unspecified");
        Truth.assertThat((Iterable)tagValueStrings).contains((Object)"global");
    }
}

