/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.MutateRowsRequest;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BulkMutationTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String APP_PROFILE = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");

    @Test
    public void test() throws TextFormat.ParseException {
        BulkMutation m = BulkMutation.create((String)TABLE_ID).add("key-a", Mutation.create().setCell("fake-family1", "fake-qualifier1", 1000L, "fake-value1").setCell("fake-family2", "fake-qualifier2", 2000L, "fake-value2")).add(ByteString.copyFromUtf8((String)"key-b"), Mutation.create().setCell("fake-family3", "fake-qualifier3", 3000L, "fake-value3"));
        MutateRowsRequest actual = m.toProto(REQUEST_CONTEXT);
        MutateRowsRequest.Builder expected = MutateRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE);
        TextFormat.merge((CharSequence)"entries {  row_key: 'key-a'  mutations {    set_cell {      family_name: 'fake-family1'      column_qualifier: 'fake-qualifier1'      timestamp_micros: 1000      value: 'fake-value1'    }  }  mutations {    set_cell {      family_name: 'fake-family2'      column_qualifier: 'fake-qualifier2'      timestamp_micros: 2000      value: 'fake-value2'    }  }}entries {  row_key: 'key-b'  mutations {    set_cell {      family_name: 'fake-family3'      column_qualifier: 'fake-qualifier3'      timestamp_micros: 3000      value: 'fake-value3'    }  }}", (Message.Builder)expected);
        Truth.assertThat((Object)actual).isEqualTo((Object)expected.build());
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        BulkMutation expected = BulkMutation.create((String)TABLE_ID).add("key-a", Mutation.create().setCell("fake-family1", "fake-qualifier1", 1000L, "fake-value1"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        BulkMutation actual = (BulkMutation)ois.readObject();
        Truth.assertThat((Object)actual.toProto(REQUEST_CONTEXT)).isEqualTo((Object)expected.toProto(REQUEST_CONTEXT));
    }

    @Test
    public void cloneTest() {
        BulkMutation originalBulkMutation = BulkMutation.create((String)TABLE_ID).add("test-rowKey", Mutation.create().setCell("fake-family1", "fake-qualifier1", 12345L, "fake-value1"));
        MutateRowsRequest originalRequest = originalBulkMutation.toProto(REQUEST_CONTEXT);
        BulkMutation clonedMutation = originalBulkMutation.clone();
        MutateRowsRequest clonedRequest = clonedMutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Object)clonedRequest).isEqualTo((Object)originalRequest);
        Truth.assertThat((String)clonedRequest.getTableName()).isEqualTo((Object)originalRequest.getTableName());
        Truth.assertThat((Iterable)clonedRequest.getEntriesList()).isEqualTo((Object)originalRequest.getEntriesList());
        clonedMutation.add("another-rowKey", Mutation.create().deleteCells("delete-family", "delete-qualifier"));
        Truth.assertThat((Object)clonedMutation.toProto(REQUEST_CONTEXT)).isNotEqualTo((Object)originalRequest);
    }

    @Test
    public void addRowMutationEntry() {
        RowMutationEntry entry = RowMutationEntry.create((String)"test-rowKey").setCell("fake-family1", "fake-qualifier1", "fake-value1");
        BulkMutation bulkMutation = BulkMutation.create((String)TABLE_ID);
        bulkMutation.add(entry);
        Truth.assertThat((Iterable)bulkMutation.toProto(REQUEST_CONTEXT).getEntriesList()).contains((Object)entry.toProto());
    }

    @Test
    public void fromProtoTest() {
        BulkMutation expected = BulkMutation.create((String)TABLE_ID).add("key", Mutation.create().setCell("fake-family", "fake-qualifier", 10000L, "fake-value"));
        MutateRowsRequest protoRequest = expected.toProto(REQUEST_CONTEXT);
        BulkMutation actualBulkMutation = BulkMutation.fromProto((MutateRowsRequest)protoRequest);
        Truth.assertThat((Object)actualBulkMutation.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        String projectId = "fresh-project";
        String instanceId = "fresh-instance";
        String appProfile = "fresh-app-profile";
        MutateRowsRequest overriddenRequest = actualBulkMutation.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).matches(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)TABLE_ID));
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
    }
}

