/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.RowFilter;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConditionalRowMutationTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String APP_PROFILE_ID = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    private static final ByteString TEST_KEY = ByteString.copyFromUtf8((String)"fake-key");

    @Test
    public void toProtoTest() {
        Mutation ignoredThenMutation = Mutation.create().deleteRow();
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).then(ignoredThenMutation);
        CheckAndMutateRowRequest actualProto = mutation.toProto(REQUEST_CONTEXT).toBuilder().clearTrueMutations().build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)CheckAndMutateRowRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRowKey(TEST_KEY).build());
    }

    @Test
    public void conditionTest() {
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).condition(Filters.FILTERS.key().regex("a.*")).then(Mutation.create().deleteRow());
        CheckAndMutateRowRequest actualProto = mutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Object)actualProto.getPredicateFilter()).isEqualTo((Object)RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"a.*")).build());
    }

    @Test
    public void thenTest() {
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).then(Mutation.create().deleteCells("family1", "qualifier1")).then(Mutation.create().deleteCells("family2", "qualifier2"));
        CheckAndMutateRowRequest actualProto = mutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Iterable)actualProto.getTrueMutationsList()).containsExactly(new Object[]{com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("family1").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier1"))).build(), com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("family2").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier2"))).build()}).inOrder();
    }

    @Test
    public void otherwiseTest() {
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).otherwise(Mutation.create().deleteCells("family1", "qualifier1")).otherwise(Mutation.create().deleteCells("family2", "qualifier2"));
        CheckAndMutateRowRequest actualProto = mutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Iterable)actualProto.getFalseMutationsList()).containsExactly(new Object[]{com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("family1").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier1"))).build(), com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("family2").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier2"))).build()}).inOrder();
    }

    @Test
    public void noEffectClausesTest() {
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).condition(Filters.FILTERS.pass());
        Throwable actualError = null;
        try {
            mutation.toProto(REQUEST_CONTEXT);
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        ConditionalRowMutation expected = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).condition(Filters.FILTERS.pass()).then(Mutation.create().deleteRow()).otherwise(Mutation.create().deleteFamily("cf"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ConditionalRowMutation actual = (ConditionalRowMutation)ois.readObject();
        Truth.assertThat((Object)actual.toProto(REQUEST_CONTEXT)).isEqualTo((Object)expected.toProto(REQUEST_CONTEXT));
    }

    @Test
    public void fromProtoTest() {
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (ByteString)TEST_KEY).condition(Filters.FILTERS.key().regex("test")).then(Mutation.create().setCell("family1", "qualifier1", 10000L, "value")).otherwise(Mutation.create().deleteFamily("family"));
        CheckAndMutateRowRequest protoRequest = mutation.toProto(REQUEST_CONTEXT);
        ConditionalRowMutation actualRequest = ConditionalRowMutation.fromProto((CheckAndMutateRowRequest)protoRequest);
        Truth.assertThat((Object)actualRequest.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        String projectId = "fresh-project";
        String instanceId = "fresh-instance";
        String appProfile = "fresh-app-profile";
        CheckAndMutateRowRequest overriddenRequest = actualRequest.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).matches(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)TABLE_ID));
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
    }
}

