/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadModifyWriteRowTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String APP_PROFILE_ID = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");

    @Test
    public void testAppend() {
        ReadModifyWriteRow mutation = ReadModifyWriteRow.create((String)TABLE_ID, (String)"fake-key").append("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), ByteString.copyFromUtf8((String)"fake-value")).append("fake-family", "fake-qualifier-str", "fake-value-str");
        ReadModifyWriteRowRequest actualProto = mutation.toProto(REQUEST_CONTEXT);
        ReadModifyWriteRowRequest expected = ReadModifyWriteRowRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRowKey(ByteString.copyFromUtf8((String)"fake-key")).addRules(ReadModifyWriteRule.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier")).setAppendValue(ByteString.copyFromUtf8((String)"fake-value"))).addRules(ReadModifyWriteRule.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier-str")).setAppendValue(ByteString.copyFromUtf8((String)"fake-value-str"))).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expected);
    }

    @Test
    public void testIncrement() {
        ReadModifyWriteRow mutation = ReadModifyWriteRow.create((String)TABLE_ID, (String)"fake-key").increment("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1L).increment("fake-family", "fake-qualifier-str", 2L);
        ReadModifyWriteRowRequest actualProto = mutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)ReadModifyWriteRowRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRowKey(ByteString.copyFromUtf8((String)"fake-key")).addRules(ReadModifyWriteRule.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier")).setIncrementAmount(1L)).addRules(ReadModifyWriteRule.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier-str")).setIncrementAmount(2L)).build());
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        ReadModifyWriteRow expected = ReadModifyWriteRow.create((String)TABLE_ID, (String)"fake-key").increment("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1L).append("fake-family", "a", "b");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ReadModifyWriteRow actual = (ReadModifyWriteRow)ois.readObject();
        Truth.assertThat((Object)actual.toProto(REQUEST_CONTEXT)).isEqualTo((Object)expected.toProto(REQUEST_CONTEXT));
    }

    @Test
    public void fromProtoTest() {
        ReadModifyWriteRow expected = ReadModifyWriteRow.create((String)TABLE_ID, (String)"row-key").increment("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1L).append("fake-family", "fake-qualifier", "fake-value");
        ReadModifyWriteRowRequest protoRequest = expected.toProto(REQUEST_CONTEXT);
        ReadModifyWriteRow actualRequest = ReadModifyWriteRow.fromProto((ReadModifyWriteRowRequest)protoRequest);
        Truth.assertThat((Object)actualRequest.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        String projectId = "fresh-project";
        String instanceId = "fresh-instance";
        String appProfile = "fresh-app-profile";
        ReadModifyWriteRowRequest overriddenRequest = actualRequest.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).matches(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)TABLE_ID));
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
    }
}

