/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.primitives.Longs;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMutationEntryTest {
    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        long timestamp = 10000L;
        RowMutationEntry underTest = RowMutationEntry.create((String)"row-key").setCell("fake-family", "qualifier-1", timestamp, "fake-values");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(underTest);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        RowMutationEntry actual = (RowMutationEntry)ois.readObject();
        Truth.assertThat((Object)actual.toProto()).isEqualTo((Object)underTest.toProto());
    }

    @Test
    public void toProtoTest() {
        long timestamp = 10000L;
        ByteString rowKey = ByteString.copyFromUtf8((String)"row-key");
        RowMutationEntry underTest = RowMutationEntry.create((ByteString)rowKey).setCell("fake-family", "qualifier-1", timestamp, "fake-values");
        MutateRowsRequest.Entry entry = underTest.toProto();
        Truth.assertThat((Object)entry).isEqualTo((Object)MutateRowsRequest.Entry.newBuilder().setRowKey(rowKey).addMutations(Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier-1")).setTimestampMicros(timestamp).setValue(ByteString.copyFromUtf8((String)"fake-values")))).build());
    }

    @Test
    public void multipleMutationTest() {
        RowMutationEntry rowEntry = RowMutationEntry.create((String)"row-key").setCell("family-1", "qualifier-1", 10000L, "fake-values").deleteCells("family-2", "qualifier-2").deleteFamily("family-3");
        ImmutableList mutationList = ImmutableList.of((Object)Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName("family-1").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier-1")).setTimestampMicros(10000L).setValue(ByteString.copyFromUtf8((String)"fake-values"))).build(), (Object)Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("family-2").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier-2"))).build(), (Object)Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName("family-3")).build());
        Truth.assertThat((Iterable)rowEntry.toProto().getMutationsList()).isEqualTo((Object)mutationList);
        rowEntry = RowMutationEntry.create((String)"row-key").deleteRow();
        Truth.assertThat((Iterable)rowEntry.toProto().getMutationsList()).hasSize(1);
        Truth.assertThat(rowEntry.toProto().getMutationsList().get(0)).isEqualTo((Object)Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.newBuilder().build()).build());
    }

    @Test
    public void unsafeMutationTest() {
        ByteString rowKey = ByteString.copyFromUtf8((String)"row-key");
        RowMutationEntry rowMutationEntry = RowMutationEntry.createUnsafe((ByteString)rowKey).setCell("family-1", "qualifier-1", 10000L, "fake-values").deleteFamily("family-2");
        MutateRowsRequest.Entry entry = rowMutationEntry.toProto();
        Truth.assertThat((Integer)entry.getMutationsCount()).isEqualTo((Object)2);
        Truth.assertThat((Iterable)entry.getMutationsList()).isEqualTo((Object)ImmutableList.of((Object)Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName("family-1").setColumnQualifier(ByteString.copyFromUtf8((String)"qualifier-1")).setTimestampMicros(10000L).setValue(ByteString.copyFromUtf8((String)"fake-values"))).build(), (Object)Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName("family-2")).build()));
    }

    @Test
    public void testWithLongValue() {
        RowMutationEntry rowMutationEntry = RowMutationEntry.create((String)"fake-key").setCell("fake-family", "fake-qualifier", 100000L).setCell("fake-family", "fake-qualifier", 30000L, 100000L);
        MutateRowsRequest.Entry entryMutation = rowMutationEntry.toProto();
        Mutation.SetCell setCell = entryMutation.getMutations(0).getSetCell();
        Truth.assertThat((String)setCell.getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((String)setCell.getColumnQualifier().toStringUtf8()).isEqualTo((Object)"fake-qualifier");
        Truth.assertThat((Iterable)setCell.getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])Longs.toByteArray((long)100000L)));
        Truth.assertThat((Object)entryMutation.getMutations(1).getSetCell()).isEqualTo((Object)Mutation.SetCell.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier")).setTimestampMicros(30000L).setValue(ByteString.copyFrom((byte[])Longs.toByteArray((long)100000L))).build());
    }
}

