/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Range;
import cz.o2.proxima.internal.shaded.com.google.common.primitives.Longs;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMutationTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String APP_PROFILE_ID = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");

    @Test
    public void toProtoTest() {
        long timestampMin = System.currentTimeMillis() * 1000L;
        RowMutation rowMutation = RowMutation.create((String)TABLE_ID, (String)"fake-key").setCell("fake-family", "fake-qualifier", "fake-value");
        MutateRowRequest actualRowMutation = rowMutation.toProto(REQUEST_CONTEXT);
        Range timestampRange = Range.closed((Comparable)Long.valueOf(timestampMin), (Comparable)Long.valueOf(System.currentTimeMillis() * 1000L));
        Truth.assertThat((String)actualRowMutation.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID));
        Truth.assertThat((String)actualRowMutation.getAppProfileId()).isEqualTo((Object)APP_PROFILE_ID);
        Truth.assertThat((Iterable)actualRowMutation.getMutationsList()).hasSize(1);
        Truth.assertThat((Iterable)actualRowMutation.getMutations(0).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((Long)actualRowMutation.getMutations(0).getSetCell().getTimestampMicros()).isIn(timestampRange);
    }

    @Test
    public void toBulkProtoTest() {
        long timestampMin = System.currentTimeMillis() * 1000L;
        RowMutation rowMutation = RowMutation.create((String)TABLE_ID, (String)"fake-key").setCell("fake-family", "fake-qualifier", "fake-value");
        MutateRowsRequest actualRowMutation = rowMutation.toBulkProto(REQUEST_CONTEXT);
        Range timestampRange = Range.closed((Comparable)Long.valueOf(timestampMin), (Comparable)Long.valueOf(System.currentTimeMillis() * 1000L));
        Truth.assertThat((String)actualRowMutation.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID));
        Truth.assertThat((String)actualRowMutation.getAppProfileId()).isEqualTo((Object)APP_PROFILE_ID);
        Truth.assertThat((Iterable)actualRowMutation.getEntriesList()).hasSize(1);
        Truth.assertThat((Iterable)actualRowMutation.getEntries(0).getMutationsList()).hasSize(1);
        Truth.assertThat((Iterable)actualRowMutation.getEntries(0).getMutations(0).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((Long)actualRowMutation.getEntries(0).getMutations(0).getSetCell().getTimestampMicros()).isIn(timestampRange);
    }

    @Test
    public void toProtoTestWithProvidedMutation() {
        Mutation mutation = Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value");
        RowMutation rowMutation = RowMutation.create((String)TABLE_ID, (String)"fake-key", (Mutation)mutation);
        MutateRowRequest actualRowMutation = rowMutation.toProto(REQUEST_CONTEXT);
        Truth.assertThat((Iterable)actualRowMutation.getMutationsList()).isEqualTo((Object)mutation.getMutations());
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        RowMutation expected = RowMutation.create((String)TABLE_ID, (String)"fake-key").setCell("fake-family", "fake-qualifier", 10000L, "fake-value");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        RowMutation actual = (RowMutation)ois.readObject();
        Truth.assertThat((Object)actual.toProto(REQUEST_CONTEXT)).isEqualTo((Object)expected.toProto(REQUEST_CONTEXT));
    }

    @Test
    public void testWithLongValue() {
        RowMutation rowMutation = RowMutation.create((String)TABLE_ID, (String)"fake-key").setCell("fake-family", "fake-qualifier", 100000L).setCell("fake-family", "fake-qualifier", 30000L, 100000L);
        MutateRowRequest actualRowMutation = rowMutation.toProto(REQUEST_CONTEXT);
        Mutation.SetCell setCell = actualRowMutation.getMutations(0).getSetCell();
        Truth.assertThat((String)setCell.getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((String)setCell.getColumnQualifier().toStringUtf8()).isEqualTo((Object)"fake-qualifier");
        Truth.assertThat((Iterable)setCell.getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])Longs.toByteArray((long)100000L)));
        Truth.assertThat((Object)actualRowMutation.getMutations(1).getSetCell()).isEqualTo((Object)Mutation.SetCell.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier")).setTimestampMicros(30000L).setValue(ByteString.copyFrom((byte[])Longs.toByteArray((long)100000L))).build());
    }

    @Test
    public void fromProtoTest() {
        RowMutation rowMutation = RowMutation.create((String)TABLE_ID, (String)"fake-key").setCell("fake-family", "fake-qualifier-1", "fake-value").setCell("fake-family", "fake-qualifier-2", 30000L, "fake-value-2");
        MutateRowRequest protoRequest = rowMutation.toProto(REQUEST_CONTEXT);
        RowMutation actualRequest = RowMutation.fromProto((MutateRowRequest)protoRequest);
        Truth.assertThat((Object)actualRequest.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        String projectId = "fresh-project";
        String instanceId = "fresh-instance";
        String appProfile = "fresh-app-profile";
        MutateRowRequest overriddenRequest = actualRequest.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).matches(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)TABLE_ID));
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
    }
}

