/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.DynamicFlowControlSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BigtableBatchingCallSettingsTest {
    private static final BatchingSettings BATCHING_SETTINGS = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(20L)).setDelayThreshold(Duration.ofMillis((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(100L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build()).build();

    @Test
    public void testEmptyBuilder() {
        BigtableBatchingCallSettings.Builder builder = BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor());
        Truth.assertThat((Object)builder.getBatchingSettings()).isNull();
        Truth.assertThat((Iterable)builder.getRetryableCodes()).isEmpty();
        Truth.assertThat((Object)builder.getRetrySettings()).isNotNull();
        Truth.assertThat((Boolean)builder.isLatencyBasedThrottlingEnabled()).isFalse();
        Truth.assertThat((Long)builder.getTargetRpcLatencyMs()).isNull();
        Truth.assertThat((Object)builder.getDynamicFlowControlSettings()).isNull();
    }

    @Test
    public void testBuilder() {
        BigtableBatchingCallSettings.Builder builder = BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor());
        ImmutableSet retryCodes = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setBatchingSettings(BATCHING_SETTINGS).setRetryableCodes((Set)retryCodes).setRetrySettings(retrySettings);
        BigtableBatchingCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getBatchingSettings()).isEqualTo((Object)BATCHING_SETTINGS);
        Truth.assertThat((Iterable)settings.getRetryableCodes()).isEqualTo((Object)retryCodes);
        Truth.assertThat((Object)settings.getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Boolean)settings.isLatencyBasedThrottlingEnabled()).isFalse();
        Truth.assertThat((Long)settings.getTargetRpcLatencyMs()).isNull();
        Truth.assertThat((Object)settings.getDynamicFlowControlSettings()).isNotNull();
        this.verifyFlowControlSettingWhenLatencyBasedThrottlingDisabled(settings.getDynamicFlowControlSettings());
        builder.enableLatencyBasedThrottling(10L);
        settings = builder.build();
        Truth.assertThat((Boolean)settings.isLatencyBasedThrottlingEnabled()).isTrue();
        Truth.assertThat((Long)settings.getTargetRpcLatencyMs()).isEqualTo((Object)10);
        Truth.assertThat((Object)settings.getDynamicFlowControlSettings()).isNotNull();
        this.verifyFlowControlSettingWhenLatencyBasedThrottlingEnabled(settings.getDynamicFlowControlSettings());
        builder.disableLatencyBasedThrottling();
        settings = builder.build();
        Truth.assertThat((Boolean)settings.isLatencyBasedThrottlingEnabled()).isFalse();
        Truth.assertThat((Long)settings.getTargetRpcLatencyMs()).isNull();
        Truth.assertThat((Object)settings.getDynamicFlowControlSettings()).isNotNull();
        this.verifyFlowControlSettingWhenLatencyBasedThrottlingDisabled(settings.getDynamicFlowControlSettings());
    }

    @Test
    public void testBuilderFromSettings() {
        BigtableBatchingCallSettings.Builder builder = BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor());
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMinutes((long)1L)).build();
        builder.setBatchingSettings(BATCHING_SETTINGS).setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNAUTHENTICATED}).setRetrySettings(retrySettings).enableLatencyBasedThrottling(10L);
        BigtableBatchingCallSettings settings = builder.build();
        BigtableBatchingCallSettings.Builder newBuilder = settings.toBuilder();
        Truth.assertThat((Object)newBuilder.getBatchingSettings()).isEqualTo((Object)BATCHING_SETTINGS);
        Truth.assertThat((Iterable)newBuilder.getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNAUTHENTICATED});
        Truth.assertThat((Object)newBuilder.getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Boolean)newBuilder.isLatencyBasedThrottlingEnabled()).isTrue();
        Truth.assertThat((Long)newBuilder.getTargetRpcLatencyMs()).isEqualTo((Object)10L);
        Truth.assertThat((Object)newBuilder.getDynamicFlowControlSettings()).isNotNull();
        this.verifyFlowControlSettingWhenLatencyBasedThrottlingEnabled(newBuilder.getDynamicFlowControlSettings());
    }

    @Test
    public void testMandatorySettings() {
        Exception actualEx = null;
        try {
            BigtableBatchingCallSettings.newBuilder(null);
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(NullPointerException.class);
        actualEx = null;
        try {
            BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor()).build();
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testFlowControlMandatorySettings() {
        Exception actualEx = null;
        try {
            BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor()).setBatchingSettings(BatchingSettings.newBuilder().setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(null).setMaxOutstandingRequestBytes(null).build()).build()).build();
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(IllegalStateException.class);
        BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor()).setBatchingSettings(BatchingSettings.newBuilder().setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(10L)).build()).build();
        actualEx = null;
        try {
            BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor()).setBatchingSettings(BatchingSettings.newBuilder().setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(5L)).build()).setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(10L)).build()).build();
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(IllegalArgumentException.class);
        actualEx = null;
        try {
            BigtableBatchingCallSettings.newBuilder((BatchingDescriptor)new MutateRowsBatchingDescriptor()).setBatchingSettings(BatchingSettings.newBuilder().setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(5L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(10L)).build()).build();
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(IllegalArgumentException.class);
    }

    private void verifyFlowControlSettingWhenLatencyBasedThrottlingDisabled(DynamicFlowControlSettings settings) {
        Truth.assertThat((Long)settings.getInitialOutstandingElementCount()).isEqualTo((Object)BATCHING_SETTINGS.getFlowControlSettings().getMaxOutstandingElementCount());
        Truth.assertThat((Long)settings.getMaxOutstandingElementCount()).isEqualTo((Object)BATCHING_SETTINGS.getFlowControlSettings().getMaxOutstandingElementCount());
        Truth.assertThat((Long)settings.getMinOutstandingElementCount()).isEqualTo((Object)BATCHING_SETTINGS.getFlowControlSettings().getMaxOutstandingElementCount());
        Truth.assertThat((Long)settings.getInitialOutstandingRequestBytes()).isEqualTo((Object)BATCHING_SETTINGS.getFlowControlSettings().getMaxOutstandingRequestBytes());
        Truth.assertThat((Long)settings.getMaxOutstandingRequestBytes()).isEqualTo((Object)BATCHING_SETTINGS.getFlowControlSettings().getMaxOutstandingRequestBytes());
        Truth.assertThat((Long)settings.getMinOutstandingRequestBytes()).isEqualTo((Object)BATCHING_SETTINGS.getFlowControlSettings().getMaxOutstandingRequestBytes());
    }

    private void verifyFlowControlSettingWhenLatencyBasedThrottlingEnabled(DynamicFlowControlSettings settings) {
        Truth.assertThat((Long)settings.getInitialOutstandingElementCount()).isLessThan((Comparable)settings.getMaxOutstandingElementCount());
        Truth.assertThat((Long)settings.getMinOutstandingElementCount()).isLessThan((Comparable)settings.getMaxOutstandingElementCount());
        Truth.assertThat((Long)settings.getInitialOutstandingRequestBytes()).isEqualTo((Object)settings.getMaxOutstandingRequestBytes());
        Truth.assertThat((Long)settings.getMinOutstandingRequestBytes()).isEqualTo((Object)settings.getMaxOutstandingRequestBytes());
    }
}

