/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.data.v2.stub.BigtableBulkReadRowsCallSettings;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsBatchingDescriptor;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BigtableBulkReadRowsCallSettingsTest {
    private static final BatchingSettings BATCHING_SETTINGS = BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(20L)).setDelayThreshold(Duration.ofMillis((long)5L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(100L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build()).build();

    @Test
    public void testEmptyBuilder() {
        BigtableBulkReadRowsCallSettings.Builder builder = BigtableBulkReadRowsCallSettings.newBuilder((BatchingDescriptor)new ReadRowsBatchingDescriptor());
        Truth.assertThat((Object)builder.getBatchingSettings()).isNull();
        Truth.assertThat((Iterable)builder.getRetryableCodes()).isEmpty();
        Truth.assertThat((Object)builder.getRetrySettings()).isNotNull();
    }

    @Test
    public void testBuilder() {
        BigtableBulkReadRowsCallSettings.Builder builder = BigtableBulkReadRowsCallSettings.newBuilder((BatchingDescriptor)new ReadRowsBatchingDescriptor());
        ImmutableSet retryCodes = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE);
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.setBatchingSettings(BATCHING_SETTINGS).setRetryableCodes((Set)retryCodes).setRetrySettings(retrySettings);
        BigtableBulkReadRowsCallSettings settings = builder.build();
        Truth.assertThat((Object)settings.getBatchingSettings()).isEqualTo((Object)BATCHING_SETTINGS);
        Truth.assertThat((Iterable)settings.getRetryableCodes()).isEqualTo((Object)retryCodes);
        Truth.assertThat((Object)settings.getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void testBuilderFromSettings() {
        BigtableBulkReadRowsCallSettings.Builder builder = BigtableBulkReadRowsCallSettings.newBuilder((BatchingDescriptor)new ReadRowsBatchingDescriptor());
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(Duration.ofMinutes((long)1L)).build();
        builder.setBatchingSettings(BATCHING_SETTINGS).setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNAUTHENTICATED}).setRetrySettings(retrySettings);
        BigtableBulkReadRowsCallSettings settings = builder.build();
        BigtableBulkReadRowsCallSettings.Builder newBuilder = settings.toBuilder();
        Truth.assertThat((Object)newBuilder.getBatchingSettings()).isEqualTo((Object)BATCHING_SETTINGS);
        Truth.assertThat((Iterable)newBuilder.getRetryableCodes()).containsExactly(new Object[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNAUTHENTICATED});
        Truth.assertThat((Object)newBuilder.getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void testMandatorySettings() {
        Exception actualEx = null;
        try {
            BigtableBulkReadRowsCallSettings.newBuilder(null);
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(NullPointerException.class);
        actualEx = null;
        try {
            BigtableBulkReadRowsCallSettings.newBuilder((BatchingDescriptor)new ReadRowsBatchingDescriptor()).build();
        }
        catch (Exception ex) {
            actualEx = ex;
        }
        Truth.assertThat((Throwable)actualEx).isInstanceOf(IllegalStateException.class);
    }
}

