/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannel;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannelBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Metadata;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCallHandler;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class BigtableChannelPrimerTest {
    private static final String TOKEN_VALUE = "fake-token";
    FakeService fakeService;
    MetadataInterceptor metadataInterceptor;
    BigtableChannelPrimer primer;
    ManagedChannel channel;
    private LogHandler logHandler;
    private Server server;

    @Before
    public void setup() throws IOException {
        this.fakeService = new FakeService();
        this.metadataInterceptor = new MetadataInterceptor();
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(this.metadataInterceptor).start();
        this.primer = BigtableChannelPrimer.create((Credentials)OAuth2Credentials.create((AccessToken)new AccessToken(TOKEN_VALUE, null)), (String)"fake-project", (String)"fake-instance", (String)"fake-app-profile");
        this.channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.server.getPort()).usePlaintext().build();
        this.logHandler = new LogHandler();
        Logger.getLogger(BigtableChannelPrimer.class.toString()).addHandler(this.logHandler);
    }

    @After
    public void teardown() {
        Logger.getLogger(BigtableChannelPrimer.class.toString()).removeHandler(this.logHandler);
        this.channel.shutdown();
        this.server.shutdown();
    }

    @Test
    public void testCredentials() {
        this.primer.primeChannel(this.channel);
        for (Metadata metadata : this.metadataInterceptor.metadataList) {
            Truth.assertThat((String)((String)metadata.get(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).isEqualTo((Object)"Bearer fake-token");
        }
        this.channel.shutdown();
    }

    @Test
    public void testRequests() {
        final ConcurrentLinkedQueue requests = new ConcurrentLinkedQueue();
        this.fakeService.pingAndWarmCallback = (ApiFunction)new ApiFunction<PingAndWarmRequest, PingAndWarmResponse>(){

            public PingAndWarmResponse apply(PingAndWarmRequest req) {
                requests.add(req);
                return PingAndWarmResponse.getDefaultInstance();
            }
        };
        this.primer.primeChannel(this.channel);
        Truth.assertThat(requests).containsExactly(new Object[]{PingAndWarmRequest.newBuilder().setName("projects/fake-project/instances/fake-instance").setAppProfileId("fake-app-profile").build()});
    }

    @Test
    public void testErrorsAreLogged() {
        this.fakeService.pingAndWarmCallback = (ApiFunction)new ApiFunction<PingAndWarmRequest, PingAndWarmResponse>(){

            public PingAndWarmResponse apply(PingAndWarmRequest pingAndWarmRequest) {
                throw new StatusRuntimeException(Status.FAILED_PRECONDITION);
            }
        };
        this.primer.primeChannel(this.channel);
        Truth.assertThat((Iterable)this.logHandler.logs).hasSize(1);
        for (LogRecord log : this.logHandler.logs) {
            Truth.assertThat((String)log.getMessage()).contains((CharSequence)"FAILED_PRECONDITION");
        }
    }

    @Test
    public void testChannelErrorsAreLogged() {
        ManagedChannel channel = (ManagedChannel)Mockito.mock(ManagedChannel.class, (Answer)new ThrowsException((Throwable)new UnsupportedOperationException()));
        this.primer.primeChannel(channel);
        Truth.assertThat((Iterable)this.logHandler.logs).hasSize(1);
        for (LogRecord log : this.logHandler.logs) {
            Truth.assertThat((String)log.getMessage()).contains((CharSequence)"UnsupportedOperationException");
        }
    }

    private static class LogHandler
    extends Handler {
        private ConcurrentLinkedQueue<LogRecord> logs = new ConcurrentLinkedQueue();

        private LogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            this.logs.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    static class FakeService
    extends BigtableGrpc.BigtableImplBase {
        private ApiFunction<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallback = new ApiFunction<PingAndWarmRequest, PingAndWarmResponse>(){

            public PingAndWarmResponse apply(PingAndWarmRequest pingAndWarmRequest) {
                return PingAndWarmResponse.getDefaultInstance();
            }
        };

        FakeService() {
        }

        public void pingAndWarm(PingAndWarmRequest request, StreamObserver<PingAndWarmResponse> responseObserver) {
            try {
                responseObserver.onNext(this.pingAndWarmCallback.apply((Object)request));
                responseObserver.onCompleted();
            }
            catch (RuntimeException e) {
                responseObserver.onError((Throwable)e);
            }
        }
    }

    private static class MetadataInterceptor
    implements ServerInterceptor {
        ConcurrentLinkedQueue<Metadata> metadataList = new ConcurrentLinkedQueue();

        private MetadataInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.metadataList.add(metadata);
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }
}

