/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.Mutation;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.protobuf.ByteString;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CheckAndMutateRowCallableTest {
    private final RequestContext requestContext = RequestContext.create((String)"my-project", (String)"my-instance", (String)"my-app-profile");
    private FakeCallable inner;
    private CheckAndMutateRowCallable callable;

    @Before
    public void setUp() {
        this.inner = new FakeCallable();
        this.callable = new CheckAndMutateRowCallable((UnaryCallable)this.inner, this.requestContext);
    }

    @Test
    public void requestIsCorrect() {
        this.callable.futureCall((Object)ConditionalRowMutation.create((String)"my-table", (String)"row-key").then(com.google.cloud.bigtable.data.v2.models.Mutation.create().deleteRow()));
        Truth.assertThat((Object)this.inner.request).isEqualTo((Object)CheckAndMutateRowRequest.newBuilder().setTableName(NameUtil.formatTableName((String)this.requestContext.getProjectId(), (String)this.requestContext.getInstanceId(), (String)"my-table")).setRowKey(ByteString.copyFromUtf8((String)"row-key")).setAppProfileId(this.requestContext.getAppProfileId()).addTrueMutations(Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.getDefaultInstance())).build());
    }

    @Test
    public void responseCorrectlyTransformed() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)ConditionalRowMutation.create((String)"my-table", (String)"row-key").then(com.google.cloud.bigtable.data.v2.models.Mutation.create().deleteRow()));
        this.inner.response.set((Object)CheckAndMutateRowResponse.newBuilder().setPredicateMatched(true).build());
        Truth.assertThat((Boolean)((Boolean)result.get(1L, TimeUnit.SECONDS))).isEqualTo((Object)true);
    }

    @Test
    public void errorIsPropagated() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)ConditionalRowMutation.create((String)"my-table", (String)"row-key").then(com.google.cloud.bigtable.data.v2.models.Mutation.create().deleteRow()));
        NotFoundException expectedError = new NotFoundException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        this.inner.response.setException((Throwable)expectedError);
        Throwable actualError = null;
        try {
            result.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            actualError = e.getCause();
        }
        Truth.assertThat((Throwable)actualError).isEqualTo((Object)expectedError);
    }

    static class FakeCallable
    extends UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> {
        CheckAndMutateRowRequest request;
        ApiCallContext callContext;
        SettableApiFuture<CheckAndMutateRowResponse> response = SettableApiFuture.create();

        FakeCallable() {
        }

        public ApiFuture<CheckAndMutateRowResponse> futureCall(CheckAndMutateRowRequest request, ApiCallContext context) {
            this.request = request;
            this.callContext = context;
            return this.response;
        }
    }
}

