/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiClock;
import com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlStats;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class DynamicFlowControlStatsTest {
    @Rule
    public final MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private ApiClock clock;

    @Test
    public void testUpdate() {
        Mockito.when((Object)this.clock.millisTime()).thenReturn((Object)0L);
        DynamicFlowControlStats stats = new DynamicFlowControlStats(0.015, this.clock);
        stats.updateLatency(10L);
        Truth.assertThat((Double)stats.getMeanLatency()).isEqualTo((Object)10);
        stats.updateLatency(10L);
        stats.updateLatency(10L);
        Truth.assertThat((Double)stats.getMeanLatency()).isEqualTo((Object)10);
        Mockito.when((Object)this.clock.millisTime()).thenReturn((Object)TimeUnit.MINUTES.toMillis(5L));
        stats.updateLatency(20L);
        Truth.assertThat((Double)stats.getMeanLatency()).isGreaterThan(19);
        Truth.assertThat((Double)stats.getMeanLatency()).isLessThan(20);
        long aDay = TimeUnit.DAYS.toMillis(1L);
        for (int i = 0; i < 10; ++i) {
            Mockito.when((Object)this.clock.millisTime()).thenReturn((Object)(aDay + TimeUnit.SECONDS.toMillis(i)));
            stats.updateLatency((long)i);
        }
        Truth.assertThat((Double)stats.getMeanLatency()).isGreaterThan((Comparable)Double.valueOf(4.5));
        Truth.assertThat((Double)stats.getMeanLatency()).isLessThan(6);
    }

    @Test(timeout=1000L)
    public void testConcurrentUpdates() throws InterruptedException, ExecutionException {
        final DynamicFlowControlStats stats = new DynamicFlowControlStats();
        ExecutorService executor = Executors.newCachedThreadPool();
        LinkedList futures = new LinkedList();
        for (int i = 1; i <= 50; ++i) {
            final long l = i;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    stats.updateLatency(l);
                }
            };
            futures.add(executor.submit(r));
        }
        for (Future future : futures) {
            future.get();
        }
        Truth.assertThat((Double)stats.getMeanLatency()).isGreaterThan(20);
        Truth.assertThat((Double)stats.getMeanLatency()).isLessThan(30);
    }
}

