/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EnhancedBigtableStubCloseRetryTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private ExecutorService testExecutor;
    private BlockingQueue<ReadRowsRequest> requests;
    private AtomicInteger numRequests;
    private Server server;
    private EnhancedBigtableStub stub;

    @Before
    public void setUp() throws Exception {
        this.testExecutor = Executors.newCachedThreadPool();
        this.requests = new ArrayBlockingQueue<ReadRowsRequest>(10);
        this.numRequests = new AtomicInteger();
        this.server = FakeServiceBuilder.create(new BindableService[]{new FakeBigtable()}).start();
        BigtableDataSettings.Builder settingBuilder = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setRefreshingChannel(false);
        this.stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settingBuilder.build().getStubSettings());
    }

    @After
    public void tearDown() throws Exception {
        this.testExecutor.shutdown();
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void outstandingRequestsFinishAfterClose() throws Exception {
        final ApiFuture resultFuture = this.stub.readRowsCallable().all().futureCall((Object)Query.create((String)"table1"));
        this.requests.take();
        Thread.sleep(100L);
        this.stub.close();
        ExecutionException error = (ExecutionException)Assert.assertThrows(ExecutionException.class, (ThrowingRunnable)new ThrowingRunnable(){

            public void run() throws Throwable {
                resultFuture.get();
            }
        });
        Truth.assertThat((Throwable)error.getCause()).isInstanceOf(RejectedExecutionException.class);
    }

    class FakeBigtable
    extends BigtableGrpc.BigtableImplBase {
        FakeBigtable() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            EnhancedBigtableStubCloseRetryTest.this.requests.add(request);
            responseObserver.onError((Throwable)Status.UNAVAILABLE.asRuntimeException());
        }
    }
}

