/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EnhancedBigtableStubCloseTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private ExecutorService testExecutor;
    private SettableFuture<Void> requestReceivedBarrier = SettableFuture.create();
    private SettableFuture<Void> clientClosedBarrier = SettableFuture.create();
    private Server server;
    private EnhancedBigtableStub stub;

    @Before
    public void setUp() throws Exception {
        this.testExecutor = Executors.newCachedThreadPool();
        this.requestReceivedBarrier = SettableFuture.create();
        this.clientClosedBarrier = SettableFuture.create();
        this.server = FakeServiceBuilder.create(new BindableService[]{new FakeBigtable()}).start();
        EnhancedBigtableStubSettings stubSettings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setRefreshingChannel(false).build().getStubSettings();
        this.stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)stubSettings);
    }

    @After
    public void tearDown() throws Exception {
        this.testExecutor.shutdown();
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void outstandingRequestsFinishAfterClose() throws Exception {
        ApiFuture resultFuture = this.stub.readRowsCallable().all().futureCall((Object)Query.create((String)"table1"));
        this.requestReceivedBarrier.get(1L, TimeUnit.MINUTES);
        this.testExecutor.submit(new Runnable(){

            @Override
            public void run() {
                EnhancedBigtableStubCloseTest.this.stub.close();
            }
        });
        Thread.sleep(200L);
        this.clientClosedBarrier.set(null);
        Truth.assertThat((Iterable)((Iterable)resultFuture.get(1L, TimeUnit.MINUTES))).isEmpty();
    }

    class FakeBigtable
    extends BigtableGrpc.BigtableImplBase {
        FakeBigtable() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            EnhancedBigtableStubCloseTest.this.requestReceivedBarrier.set(null);
            try {
                EnhancedBigtableStubCloseTest.this.clientClosedBarrier.get();
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)e);
            }
            responseObserver.onCompleted();
        }
    }
}

