/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Range;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class EnhancedBigtableStubSettingsTest {
    static final String[] SETTINGS_LIST = new String[]{"projectId", "instanceId", "appProfileId", "isRefreshingChannel", "primedTableIds", "jwtAudienceMapping", "readRowsSettings", "readRowSettings", "sampleRowKeysSettings", "mutateRowSettings", "bulkMutateRowsSettings", "bulkReadRowsSettings", "checkAndMutateRowSettings", "readModifyWriteRowSettings", "pingAndWarmSettings"};

    @Test
    public void instanceNameIsRequiredTest() {
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder();
        Throwable error = null;
        try {
            builder.build();
        }
        catch (Throwable t) {
            error = t;
        }
        Truth.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void settingsAreNotLostTest() {
        String projectId = "my-project";
        String instanceId = "my-instance";
        String appProfileId = "my-app-profile-id";
        boolean isRefreshingChannel = false;
        String endpoint = "some.other.host:123";
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        WatchdogProvider watchdogProvider = (WatchdogProvider)Mockito.mock(WatchdogProvider.class);
        Duration watchdogInterval = Duration.ofSeconds((long)12L);
        EnhancedBigtableStubSettings.Builder builder = (EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).setAppProfileId(appProfileId).setRefreshingChannel(isRefreshingChannel).setEndpoint(endpoint)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).setStreamWatchdogCheckInterval(watchdogInterval);
        this.verifyBuilder(builder, projectId, instanceId, appProfileId, isRefreshingChannel, endpoint, credentialsProvider, watchdogProvider, watchdogInterval);
        this.verifySettings(builder.build(), projectId, instanceId, appProfileId, isRefreshingChannel, endpoint, credentialsProvider, watchdogProvider, watchdogInterval);
        this.verifyBuilder(builder.build().toBuilder(), projectId, instanceId, appProfileId, isRefreshingChannel, endpoint, credentialsProvider, watchdogProvider, watchdogInterval);
    }

    private void verifyBuilder(EnhancedBigtableStubSettings.Builder builder, String projectId, String instanceId, String appProfileId, boolean isRefreshingChannel, String endpoint, CredentialsProvider credentialsProvider, WatchdogProvider watchdogProvider, Duration watchdogInterval) {
        Truth.assertThat((String)builder.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((String)builder.getInstanceId()).isEqualTo((Object)instanceId);
        Truth.assertThat((String)builder.getAppProfileId()).isEqualTo((Object)appProfileId);
        Truth.assertThat((Boolean)builder.isRefreshingChannel()).isEqualTo((Object)isRefreshingChannel);
        Truth.assertThat((String)builder.getEndpoint()).isEqualTo((Object)endpoint);
        Truth.assertThat((Object)builder.getCredentialsProvider()).isEqualTo((Object)credentialsProvider);
        Truth.assertThat((Object)builder.getStreamWatchdogProvider()).isSameInstanceAs((Object)watchdogProvider);
        Truth.assertThat((Comparable)builder.getStreamWatchdogCheckInterval()).isEqualTo((Object)watchdogInterval);
    }

    private void verifySettings(EnhancedBigtableStubSettings settings, String projectId, String instanceId, String appProfileId, boolean isRefreshingChannel, String endpoint, CredentialsProvider credentialsProvider, WatchdogProvider watchdogProvider, Duration watchdogInterval) {
        Truth.assertThat((String)settings.getProjectId()).isEqualTo((Object)projectId);
        Truth.assertThat((String)settings.getInstanceId()).isEqualTo((Object)instanceId);
        Truth.assertThat((String)settings.getAppProfileId()).isEqualTo((Object)appProfileId);
        Truth.assertThat((Boolean)settings.isRefreshingChannel()).isEqualTo((Object)isRefreshingChannel);
        Truth.assertThat((String)settings.getEndpoint()).isEqualTo((Object)endpoint);
        Truth.assertThat((Object)settings.getCredentialsProvider()).isEqualTo((Object)credentialsProvider);
        Truth.assertThat((Object)settings.getStreamWatchdogProvider()).isSameInstanceAs((Object)watchdogProvider);
        Truth.assertThat((Comparable)settings.getStreamWatchdogCheckInterval()).isEqualTo((Object)watchdogInterval);
    }

    @Test
    public void multipleChannelsByDefaultTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        InstantiatingGrpcChannelProvider provider = (InstantiatingGrpcChannelProvider)builder.getTransportChannelProvider();
        Truth.assertThat((Integer)provider.toBuilder().getPoolSize()).isGreaterThan((Comparable)Integer.valueOf(1));
    }

    @Test
    public void readRowsIsNotLostTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(10).setTotalTimeout(Duration.ofHours((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)10L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)10L)).setJittered(true).build();
        builder.readRowsSettings().setIdleTimeout(Duration.ofMinutes((long)5L)).setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).build();
        builder.readRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED});
        builder.bulkReadRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED});
        Truth.assertThat((Comparable)builder.readRowsSettings().getIdleTimeout()).isEqualTo((Object)Duration.ofMinutes((long)5L));
        Truth.assertThat((Iterable)builder.readRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.readRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Comparable)builder.build().readRowsSettings().getIdleTimeout()).isEqualTo((Object)Duration.ofMinutes((long)5L));
        Truth.assertThat((Iterable)builder.build().readRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().readRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Comparable)builder.build().toBuilder().readRowsSettings().getIdleTimeout()).isEqualTo((Object)Duration.ofMinutes((long)5L));
        Truth.assertThat((Iterable)builder.build().toBuilder().readRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().readRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void readRowsHasSaneDefaultsTest() {
        ServerStreamingCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().readRowsSettings();
        this.verifyRetrySettingAreSane(builder.getRetryableCodes(), builder.getRetrySettings());
        Truth.assertThat((Iterable)builder.getRetryableCodes()).containsExactlyElementsIn((Iterable)ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE, (Object)StatusCode.Code.ABORTED));
    }

    @Test
    public void readRowIsNotLostTest() {
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId("my-project").setInstanceId("my-instance");
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(10).setTotalTimeout(Duration.ofHours((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)10L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)10L)).setJittered(true).build();
        builder.readRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).build();
        builder.readRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED});
        builder.bulkReadRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED});
        Truth.assertThat((Iterable)builder.readRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.readRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().readRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().readRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().toBuilder().readRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().readRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void readRowHasSaneDefaultsTest() {
        UnaryCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().readRowSettings();
        this.verifyRetrySettingAreSane(builder.getRetryableCodes(), builder.getRetrySettings());
        Truth.assertThat((Iterable)builder.getRetryableCodes()).containsExactlyElementsIn((Iterable)ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE, (Object)StatusCode.Code.ABORTED));
    }

    @Test
    public void readRowRetryCodesMustMatch() {
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId("my-project").setInstanceId("my-instance");
        builder.readRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED});
        builder.readRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED});
        Exception actualError = null;
        try {
            builder.build();
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isNotNull();
        builder.readRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED});
        builder.bulkReadRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED});
        actualError = null;
        try {
            builder.build();
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isNull();
    }

    @Test
    public void sampleRowKeysSettingsAreNotLostTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(10).setTotalTimeout(Duration.ofHours((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)10L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)10L)).setJittered(true).build();
        builder.sampleRowKeysSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).build();
        Truth.assertThat((Iterable)builder.sampleRowKeysSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.sampleRowKeysSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().sampleRowKeysSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().sampleRowKeysSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().toBuilder().sampleRowKeysSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().sampleRowKeysSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void sampleRowKeysHasSaneDefaultsTest() {
        UnaryCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().sampleRowKeysSettings();
        this.verifyRetrySettingAreSane(builder.getRetryableCodes(), builder.getRetrySettings());
    }

    @Test
    public void mutateRowSettingsAreNotLostTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(10).setTotalTimeout(Duration.ofHours((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)10L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)10L)).setJittered(true).build();
        builder.mutateRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).build();
        Truth.assertThat((Iterable)builder.mutateRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.mutateRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().mutateRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().mutateRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().toBuilder().mutateRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().mutateRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void mutateRowHasSaneDefaultsTest() {
        UnaryCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().mutateRowSettings();
        this.verifyRetrySettingAreSane(builder.getRetryableCodes(), builder.getRetrySettings());
    }

    @Test
    public void bulkMutateRowsSettingsAreNotLostTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        Truth.assertThat((Boolean)builder.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()).isFalse();
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(10).setTotalTimeout(Duration.ofHours((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)10L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)10L)).setJittered(true).build();
        long flowControlSetting = 10L;
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(10L)).setMaxOutstandingRequestBytes(Long.valueOf(10L)).build()).build();
        long targetLatency = 10L;
        builder.bulkMutateRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).setBatchingSettings(batchingSettings).enableLatencyBasedThrottling(targetLatency).build();
        Truth.assertThat((Iterable)builder.bulkMutateRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.bulkMutateRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Object)builder.bulkMutateRowsSettings().getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Boolean)builder.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()).isTrue();
        Truth.assertThat((Long)builder.bulkMutateRowsSettings().getTargetRpcLatencyMs()).isEqualTo((Object)targetLatency);
        Truth.assertThat((Long)builder.bulkMutateRowsSettings().getDynamicFlowControlSettings().getMaxOutstandingElementCount()).isEqualTo((Object)flowControlSetting);
        Truth.assertThat((Long)builder.bulkMutateRowsSettings().getDynamicFlowControlSettings().getMaxOutstandingRequestBytes()).isEqualTo((Object)flowControlSetting);
        Truth.assertThat((Iterable)builder.build().bulkMutateRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().bulkMutateRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Object)builder.build().bulkMutateRowsSettings().getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Boolean)builder.build().bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()).isTrue();
        Truth.assertThat((Long)builder.build().bulkMutateRowsSettings().getTargetRpcLatencyMs()).isEqualTo((Object)targetLatency);
        Truth.assertThat((Long)builder.build().bulkMutateRowsSettings().getDynamicFlowControlSettings().getMaxOutstandingElementCount()).isEqualTo((Object)flowControlSetting);
        Truth.assertThat((Long)builder.build().bulkMutateRowsSettings().getDynamicFlowControlSettings().getMaxOutstandingRequestBytes()).isEqualTo((Object)flowControlSetting);
        Truth.assertThat((Iterable)builder.build().toBuilder().bulkMutateRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().bulkMutateRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Object)builder.build().toBuilder().bulkMutateRowsSettings().getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Boolean)builder.build().toBuilder().bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()).isTrue();
        Truth.assertThat((Long)builder.build().toBuilder().bulkMutateRowsSettings().getTargetRpcLatencyMs()).isEqualTo((Object)targetLatency);
        Truth.assertThat((Long)builder.build().toBuilder().bulkMutateRowsSettings().getDynamicFlowControlSettings().getMaxOutstandingElementCount()).isEqualTo((Object)flowControlSetting);
        Truth.assertThat((Long)builder.build().toBuilder().bulkMutateRowsSettings().getDynamicFlowControlSettings().getMaxOutstandingRequestBytes()).isEqualTo((Object)flowControlSetting);
    }

    @Test
    public void bulkReadRowsSettingsAreNotLostTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(10).setTotalTimeout(Duration.ofHours((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)10L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)10L)).setJittered(true).build();
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().build();
        builder.bulkReadRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).setBatchingSettings(batchingSettings).build();
        builder.readRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED});
        builder.readRowsSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED});
        Truth.assertThat((Iterable)builder.bulkReadRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.bulkReadRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Object)builder.bulkReadRowsSettings().getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Iterable)builder.build().bulkReadRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().bulkReadRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Object)builder.build().bulkReadRowsSettings().getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
        Truth.assertThat((Iterable)builder.build().toBuilder().bulkReadRowsSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().bulkReadRowsSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Object)builder.build().toBuilder().bulkReadRowsSettings().getBatchingSettings()).isSameInstanceAs((Object)batchingSettings);
    }

    @Test
    public void mutateRowsHasSaneDefaultsTest() {
        BigtableBatchingCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().bulkMutateRowsSettings();
        this.verifyRetrySettingAreSane(builder.getRetryableCodes(), builder.getRetrySettings());
        Truth.assertThat((Comparable)builder.getBatchingSettings().getDelayThreshold()).isIn(Range.open((Comparable)Duration.ZERO, (Comparable)Duration.ofMinutes((long)1L)));
        Truth.assertThat((Long)builder.getBatchingSettings().getElementCountThreshold()).isIn(Range.open((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1000L)));
        Truth.assertThat((Boolean)builder.getBatchingSettings().getIsEnabled()).isTrue();
        Truth.assertThat((Long)builder.getBatchingSettings().getRequestByteThreshold()).isLessThan((Comparable)Long.valueOf(0x10000000L));
        Truth.assertThat((Long)builder.getBatchingSettings().getFlowControlSettings().getMaxOutstandingElementCount()).isAtMost((Comparable)Long.valueOf(20000L));
        Truth.assertThat((Long)builder.getBatchingSettings().getFlowControlSettings().getMaxOutstandingRequestBytes()).isLessThan((Comparable)Long.valueOf(0x20000000L));
    }

    @Test
    public void checkAndMutateRowSettingsAreNotLostTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        RetrySettings retrySettings = RetrySettings.newBuilder().build();
        builder.checkAndMutateRowSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.ABORTED, StatusCode.Code.DEADLINE_EXCEEDED}).setRetrySettings(retrySettings).build();
        Truth.assertThat((Iterable)builder.checkAndMutateRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.checkAndMutateRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().checkAndMutateRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().checkAndMutateRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
        Truth.assertThat((Iterable)builder.build().toBuilder().checkAndMutateRowSettings().getRetryableCodes()).containsAtLeast((Object)StatusCode.Code.ABORTED, (Object)StatusCode.Code.DEADLINE_EXCEEDED, new Object[0]);
        Truth.assertThat((Object)builder.build().toBuilder().checkAndMutateRowSettings().getRetrySettings()).isEqualTo((Object)retrySettings);
    }

    @Test
    public void checkAndMutateRowSettingsAreSane() {
        UnaryCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().checkAndMutateRowSettings();
        Truth.assertThat((Integer)builder.getRetrySettings().getMaxAttempts()).isAtMost((Comparable)Integer.valueOf(1));
        Truth.assertThat((Iterable)builder.getRetryableCodes()).isEmpty();
    }

    @Test
    public void pingAndWarmRetriesAreDisabled() {
        UnaryCallSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().pingAndWarmSettings();
        Truth.assertThat((Integer)builder.getRetrySettings().getMaxAttempts()).isAtMost((Comparable)Integer.valueOf(1));
        Truth.assertThat((Comparable)builder.getRetrySettings().getInitialRpcTimeout()).isAtMost((Comparable)Duration.ofSeconds((long)30L));
    }

    private void verifyRetrySettingAreSane(Set<StatusCode.Code> retryCodes, RetrySettings retrySettings) {
        Truth.assertThat(retryCodes).containsAtLeast((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE, new Object[0]);
        Truth.assertThat((Comparable)retrySettings.getTotalTimeout()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Comparable)retrySettings.getInitialRetryDelay()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Double)retrySettings.getRetryDelayMultiplier()).isAtLeast((Comparable)Double.valueOf(1.0));
        Truth.assertThat((Comparable)retrySettings.getMaxRetryDelay()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Comparable)retrySettings.getInitialRpcTimeout()).isGreaterThan((Comparable)Duration.ZERO);
        Truth.assertThat((Double)retrySettings.getRpcTimeoutMultiplier()).isAtLeast((Comparable)Double.valueOf(1.0));
        Truth.assertThat((Comparable)retrySettings.getMaxRpcTimeout()).isGreaterThan((Comparable)Duration.ZERO);
    }

    @Test
    public void isRefreshingChannelDefaultValueTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId);
        Truth.assertThat((Boolean)builder.isRefreshingChannel()).isFalse();
        Truth.assertThat((Boolean)builder.build().isRefreshingChannel()).isFalse();
        Truth.assertThat((Boolean)builder.build().toBuilder().isRefreshingChannel()).isFalse();
    }

    @Test
    public void isRefreshingChannelFalseValueTest() {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        EnhancedBigtableStubSettings.Builder builder = EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId).setRefreshingChannel(false);
        Truth.assertThat((Boolean)builder.isRefreshingChannel()).isFalse();
        Truth.assertThat((Boolean)builder.build().isRefreshingChannel()).isFalse();
        Truth.assertThat((Boolean)builder.build().toBuilder().isRefreshingChannel()).isFalse();
    }

    @Test
    public void testToString() {
        EnhancedBigtableStubSettings defaultSettings = EnhancedBigtableStubSettings.newBuilder().setProjectId("our-project-85").setInstanceId("our-instance-06").setAppProfileId("our-appProfile-06").build();
        this.checkToString(defaultSettings);
        Truth.assertThat((String)defaultSettings.toString()).contains((CharSequence)"primedTableIds=[]");
        EnhancedBigtableStubSettings settings = ((EnhancedBigtableStubSettings.Builder)defaultSettings.toBuilder().setPrimedTableIds(new String[]{"2", "12", "85", "06"}).setEndpoint("example.com:1234")).build();
        this.checkToString(settings);
        Truth.assertThat((String)settings.toString()).contains((CharSequence)"endpoint=example.com:1234");
        Truth.assertThat((String)settings.toString()).contains((CharSequence)"primedTableIds=[2, 12, 85, 06]");
        int nonStaticFields = 0;
        for (Field field : EnhancedBigtableStubSettings.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            ++nonStaticFields;
        }
        Truth.assertThat((Integer)SETTINGS_LIST.length).isEqualTo((Object)nonStaticFields);
    }

    void checkToString(EnhancedBigtableStubSettings settings) {
        String projectId = settings.getProjectId();
        String instanceId = settings.getInstanceId();
        String appProfileId = settings.getAppProfileId();
        String isRefreshingChannel = "" + settings.isRefreshingChannel();
        String toString = settings.toString();
        Truth.assertThat((String)toString).isEqualTo((Object)settings.toString());
        Truth.assertThat((String)toString).startsWith("EnhancedBigtableStubSettings{projectId=" + projectId + ", instanceId=" + instanceId + ", appProfileId=" + appProfileId + ", isRefreshingChannel=" + isRefreshingChannel);
        for (String subSettings : SETTINGS_LIST) {
            Truth.assertThat((String)toString).contains((CharSequence)(subSettings + "="));
        }
    }

    @Test
    public void refreshingChannelSetFixedCredentialProvider() throws Exception {
        String dummyProjectId = "my-project";
        String dummyInstanceId = "my-instance";
        CredentialsProvider credentialsProvider = (CredentialsProvider)Mockito.mock(CredentialsProvider.class);
        FakeCredentials expectedCredentials = new FakeCredentials();
        Mockito.when((Object)credentialsProvider.getCredentials()).thenReturn((Object)expectedCredentials, (Object[])new Credentials[]{new FakeCredentials(), new FakeCredentials()});
        EnhancedBigtableStubSettings.Builder builder = (EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(dummyProjectId).setInstanceId(dummyInstanceId).setRefreshingChannel(true).setCredentialsProvider(credentialsProvider);
        Truth.assertThat((Boolean)builder.isRefreshingChannel()).isTrue();
        EnhancedBigtableStubSettings stubSettings = builder.build();
        Truth.assertThat((Boolean)stubSettings.isRefreshingChannel()).isTrue();
        Truth.assertThat((Object)stubSettings.getCredentialsProvider()).isInstanceOf(FixedCredentialsProvider.class);
        Truth.assertThat((Object)stubSettings.getCredentialsProvider().getCredentials()).isEqualTo((Object)expectedCredentials);
        Truth.assertThat((Boolean)stubSettings.toBuilder().isRefreshingChannel()).isTrue();
        Truth.assertThat((Object)stubSettings.toBuilder().getCredentialsProvider().getCredentials()).isEqualTo((Object)expectedCredentials);
    }

    private static class FakeCredentials
    extends Credentials {
        private FakeCredentials() {
        }

        public String getAuthenticationType() {
            return "fake";
        }

        public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
            return ImmutableMap.of((Object)"my-header", Arrays.asList("fake-credential"));
        }

        public boolean hasRequestMetadata() {
            return true;
        }

        public boolean hasRequestMetadataOnly() {
            return true;
        }

        public void refresh() throws IOException {
        }
    }
}

