/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Context;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Deadline;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannel;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannelBuilder;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Metadata;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCallHandler;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.internal.GrpcUtil;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Queues;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class EnhancedBigtableStubTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_NAME = NameUtil.formatTableName((String)"fake-project", (String)"fake-instance", (String)"fake-table");
    private static final String APP_PROFILE_ID = "app-profile-id";
    private Server server;
    private MetadataInterceptor metadataInterceptor;
    private ContextInterceptor contextInterceptor;
    private FakeDataService fakeDataService;
    private EnhancedBigtableStubSettings defaultSettings;
    private EnhancedBigtableStub enhancedBigtableStub;

    @Before
    public void setUp() throws IOException, IllegalAccessException, InstantiationException {
        this.metadataInterceptor = new MetadataInterceptor();
        this.contextInterceptor = new ContextInterceptor();
        this.fakeDataService = new FakeDataService();
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeDataService}).intercept(this.contextInterceptor).intercept(this.metadataInterceptor).start();
        this.defaultSettings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).build().getStubSettings();
        this.enhancedBigtableStub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)this.defaultSettings);
    }

    @After
    public void tearDown() {
        this.enhancedBigtableStub.close();
        this.server.shutdown();
    }

    @Test
    public void testJwtAudience() throws InterruptedException, IOException, NoSuchAlgorithmException, ExecutionException {
        this.enhancedBigtableStub.close();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair keyPair = keyGen.genKeyPair();
        ServiceAccountJwtAccessCredentials jwtCreds = ServiceAccountJwtAccessCredentials.newBuilder().setClientId("fake-id").setClientEmail("fake@example.com").setPrivateKey(keyPair.getPrivate()).setPrivateKeyId("fake-private-key").build();
        String expectedAudience = "http://localaudience";
        EnhancedBigtableStubSettings settings = ((EnhancedBigtableStubSettings.Builder)this.defaultSettings.toBuilder().setJwtAudienceMapping((Map)ImmutableMap.of((Object)"localhost", (Object)expectedAudience)).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)jwtCreds))).build();
        this.enhancedBigtableStub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);
        this.enhancedBigtableStub.readRowCallable().futureCall((Object)Query.create((String)"fake-table")).get();
        Metadata metadata = this.metadataInterceptor.headers.take();
        String authValue = (String)metadata.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        String expectedPrefix = "Bearer ";
        Truth.assertThat((String)authValue).startsWith(expectedPrefix);
        String jwtStr = authValue.substring(expectedPrefix.length());
        JsonWebSignature parsed = JsonWebSignature.parse((JsonFactory)GsonFactory.getDefaultInstance(), (String)jwtStr);
        Truth.assertThat((Object)parsed.getPayload().getAudience()).isEqualTo((Object)expectedAudience);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchJwtAudience() throws InterruptedException, IOException, NoSuchAlgorithmException, ExecutionException {
        Metadata metadata;
        this.enhancedBigtableStub.close();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair keyPair = keyGen.genKeyPair();
        ServiceAccountJwtAccessCredentials jwtCreds = ServiceAccountJwtAccessCredentials.newBuilder().setClientId("fake-id").setClientEmail("fake@example.com").setPrivateKey(keyPair.getPrivate()).setPrivateKeyId("fake-private-key").build();
        ManagedChannel emulatorChannel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.server.getPort()).usePlaintext().build();
        try {
            EnhancedBigtableStubSettings settings = ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setEndpoint("batch-bigtable.googleapis.com:443")).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)jwtCreds))).setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)emulatorChannel)))).build();
            this.enhancedBigtableStub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);
            this.enhancedBigtableStub.readRowCallable().futureCall((Object)Query.create((String)"fake-table")).get();
            metadata = this.metadataInterceptor.headers.take();
        }
        finally {
            emulatorChannel.shutdown();
        }
        String authValue = (String)metadata.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        String expectedPrefix = "Bearer ";
        Truth.assertThat((String)authValue).startsWith(expectedPrefix);
        String jwtStr = authValue.substring(expectedPrefix.length());
        JsonWebSignature parsed = JsonWebSignature.parse((JsonFactory)GsonFactory.getDefaultInstance(), (String)jwtStr);
        Truth.assertThat((Object)parsed.getPayload().getAudience()).isEqualTo((Object)"https://bigtable.googleapis.com/");
    }

    @Test
    public void testCreateReadRowsCallable() throws InterruptedException {
        ServerStreamingCallable streamingCallable = this.enhancedBigtableStub.createReadRowsCallable((RowAdapter)new DefaultRowAdapter());
        Query request = Query.create((String)"table-id").rowKey("row-key");
        streamingCallable.call((Object)request).iterator().next();
        ReadRowsRequest expected = request.toProto(RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID));
        Truth.assertThat((Object)this.fakeDataService.popLastRequest()).isEqualTo((Object)expected);
    }

    @Test
    public void testCreateReadRowsRawCallable() throws InterruptedException {
        ServerStreamingCallable callable = this.enhancedBigtableStub.createReadRowsRawCallable((RowAdapter)new DefaultRowAdapter());
        ReadRowsRequest expectedRequest = ReadRowsRequest.newBuilder().setTableName(TABLE_NAME).setAppProfileId("app-profile-1").setRows(RowSet.newBuilder().addRowKeys(ByteString.copyFromUtf8((String)"test-row-key"))).build();
        callable.call((Object)expectedRequest).iterator().next();
        Truth.assertThat((Object)this.fakeDataService.popLastRequest()).isEqualTo((Object)expectedRequest);
        ReadRowsRequest expectedRequest2 = ReadRowsRequest.newBuilder().setTableName(TABLE_NAME).setAppProfileId("app-profile-2").build();
        callable.call((Object)expectedRequest2).iterator().next();
        Truth.assertThat((Object)this.fakeDataService.popLastRequest()).isEqualTo((Object)expectedRequest2);
    }

    @Test
    public void testChannelPrimerConfigured() throws IOException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).build();
        try (EnhancedBigtableStub ignored = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            Truth.assertThat(this.fakeDataService.pingRequests).hasSize(1);
        }
    }

    @Test
    public void testUserAgent() throws InterruptedException {
        ServerStreamingCallable streamingCallable = this.enhancedBigtableStub.createReadRowsCallable((RowAdapter)new DefaultRowAdapter());
        Query request = Query.create((String)"table-id").rowKey("row-key");
        streamingCallable.call((Object)request).iterator().next();
        Truth.assertThat(this.metadataInterceptor.headers).hasSize(1);
        Metadata metadata = this.metadataInterceptor.headers.take();
        Truth.assertThat((String)((String)metadata.get(Metadata.Key.of((String)"user-agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).containsMatch("bigtable-java/\\d+\\.\\d+\\.\\d+(?:-SNAPSHOT)?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpanAttributes() throws InterruptedException {
        final ArrayBlockingQueue spans = new ArrayBlockingQueue(100);
        String handlerName = "stub-test-exporter";
        Tracing.getExportComponent().getSpanExporter().registerHandler(handlerName, new SpanExporter.Handler(){

            public void export(Collection<SpanData> collection) {
                spans.addAll(collection);
            }
        });
        SpanData foundSpanData = null;
        try {
            try (Scope ignored = Tracing.getTracer().spanBuilder("fake-parent-span").setSampler(Samplers.alwaysSample()).startScopedSpan();){
                this.enhancedBigtableStub.readRowCallable().call((Object)Query.create((String)"table-id").rowKey("row-key"));
            }
            for (int i = 0; i < 100; ++i) {
                SpanData spanData = (SpanData)spans.poll(10L, TimeUnit.SECONDS);
                if (!"Bigtable.ReadRow".equals(spanData.getName())) continue;
                foundSpanData = spanData;
                break;
            }
        }
        finally {
            Tracing.getExportComponent().getSpanExporter().unregisterHandler(handlerName);
        }
        Truth.assertThat(foundSpanData).isNotNull();
        Truth.assertThat((Map)foundSpanData.getAttributes().getAttributeMap()).containsEntry((Object)"gapic", (Object)AttributeValue.stringAttributeValue((String)Version.VERSION));
        Truth.assertThat((Map)foundSpanData.getAttributes().getAttributeMap()).containsEntry((Object)"grpc", (Object)AttributeValue.stringAttributeValue((String)GrpcUtil.getGrpcBuildVersion().getImplementationVersion()));
        Truth.assertThat((Map)foundSpanData.getAttributes().getAttributeMap()).containsEntry((Object)"gax", (Object)AttributeValue.stringAttributeValue((String)GaxGrpcProperties.getGaxGrpcVersion()));
    }

    @Test
    public void testBulkMutationFlowControllerConfigured() throws Exception {
        Throwable throwable;
        Throwable throwable2;
        EnhancedBigtableStub stub2;
        BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilder().setProjectId("my-project").setInstanceId("my-instance").setCredentialsProvider(this.defaultSettings.getCredentialsProvider()).enableBatchMutationLatencyBasedThrottling(10L);
        settings.stubSettings().bulkMutateRowsSettings().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(50L)).setRequestByteThreshold(Long.valueOf(500L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(1000L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build()).build()).build();
        try (EnhancedBigtableStub stub1 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build().getStubSettings());){
            stub2 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build().getStubSettings());
            throwable2 = null;
            try {
                Throwable throwable3;
                BatcherImpl batcher22;
                throwable = null;
                try (BatcherImpl batcher1 = (BatcherImpl)stub1.newMutateRowsBatcher("my-table1", null);){
                    batcher22 = (BatcherImpl)stub1.newMutateRowsBatcher("my-table2", null);
                    throwable3 = null;
                    try {
                        Truth.assertThat((Object)batcher1.getFlowController()).isNotNull();
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isNotNull();
                        Truth.assertThat((Object)batcher1).isNotSameInstanceAs((Object)batcher22);
                        Truth.assertThat((Object)batcher1.getFlowController()).isSameInstanceAs((Object)batcher22.getFlowController());
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isSameInstanceAs((Object)batcher22.getFlowController().getFlowControlEventStats());
                        Truth.assertThat((Long)batcher1.getFlowController().getMaxElementCountLimit()).isEqualTo((Object)100L);
                        Truth.assertThat((Long)batcher1.getFlowController().getMaxRequestBytesLimit()).isEqualTo((Object)1000L);
                        Truth.assertThat((Long)batcher1.getFlowController().getCurrentElementCountLimit()).isLessThan((Comparable)Long.valueOf(100L));
                        Truth.assertThat((Long)batcher1.getFlowController().getCurrentRequestBytesLimit()).isEqualTo((Object)1000L);
                        Truth.assertThat((Long)batcher1.getFlowController().getMinElementCountLimit()).isAtLeast((Comparable)settings.stubSettings().bulkMutateRowsSettings().getBatchingSettings().getElementCountThreshold());
                        Truth.assertThat((Long)batcher1.getFlowController().getMinRequestBytesLimit()).isEqualTo((Object)1000L);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (batcher22 != null) {
                            if (throwable3 != null) {
                                try {
                                    batcher22.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                            } else {
                                batcher22.close();
                            }
                        }
                    }
                }
                catch (Throwable batcher22) {
                    throwable = batcher22;
                    throw batcher22;
                }
                batcher1 = (BatcherImpl)stub1.newMutateRowsBatcher("my-table1", null);
                throwable = null;
                try {
                    batcher22 = (BatcherImpl)stub2.newMutateRowsBatcher("my-table2", null);
                    throwable3 = null;
                    try {
                        Truth.assertThat((Object)batcher1.getFlowController()).isNotNull();
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isNotNull();
                        Truth.assertThat((Object)batcher1.getFlowController()).isNotSameInstanceAs((Object)batcher22.getFlowController());
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isNotSameInstanceAs((Object)batcher22.getFlowController().getFlowControlEventStats());
                    }
                    catch (Throwable throwable6) {
                        throwable3 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (batcher22 != null) {
                            if (throwable3 != null) {
                                try {
                                    batcher22.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable3.addSuppressed(throwable7);
                                }
                            } else {
                                batcher22.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (batcher1 != null) {
                        if (throwable != null) {
                            try {
                                batcher1.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            batcher1.close();
                        }
                    }
                }
            }
            catch (Throwable batcher1) {
                throwable2 = batcher1;
                throw batcher1;
            }
            finally {
                if (stub2 != null) {
                    if (throwable2 != null) {
                        try {
                            stub2.close();
                        }
                        catch (Throwable batcher1) {
                            throwable2.addSuppressed(batcher1);
                        }
                    } else {
                        stub2.close();
                    }
                }
            }
        }
        stub1 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build().getStubSettings());
        var3_3 = null;
        try {
            stub2 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.disableBatchMutationLatencyBasedThrottling().build().getStubSettings());
            throwable2 = null;
            try {
                throwable = null;
                try (BatcherImpl batcher = (BatcherImpl)stub2.newMutateRowsBatcher("my-table", null);){
                    Truth.assertThat((Long)batcher.getFlowController().getMaxElementCountLimit()).isEqualTo((Object)100L);
                    Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isEqualTo((Object)100L);
                    Truth.assertThat((Long)batcher.getFlowController().getMinElementCountLimit()).isEqualTo((Object)100L);
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
            }
            catch (Throwable throwable11) {
                throwable2 = throwable11;
                throw throwable11;
            }
            finally {
                if (stub2 != null) {
                    if (throwable2 != null) {
                        try {
                            stub2.close();
                        }
                        catch (Throwable throwable12) {
                            throwable2.addSuppressed(throwable12);
                        }
                    } else {
                        stub2.close();
                    }
                }
            }
        }
        catch (Throwable throwable13) {
            var3_3 = throwable13;
            throw throwable13;
        }
        finally {
            if (stub1 != null) {
                if (var3_3 != null) {
                    try {
                        stub1.close();
                    }
                    catch (Throwable throwable14) {
                        var3_3.addSuppressed(throwable14);
                    }
                } else {
                    stub1.close();
                }
            }
        }
    }

    @Test
    public void testCallContextPropagatedInMutationBatcher() throws IOException, InterruptedException, ExecutionException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).setPrimedTableIds(new String[]{"table1", "table2"}).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            this.contextInterceptor.contexts.clear();
            GrpcCallContext clientCtx = GrpcCallContext.createDefault().withTimeout(Duration.ofMinutes((long)10L));
            try (Batcher batcher = stub.newMutateRowsBatcher("table1", clientCtx);){
                batcher.add((Object)RowMutationEntry.create((String)"key").deleteRow()).get();
            }
            Context serverCtx = (Context)this.contextInterceptor.contexts.poll();
            Truth.assertThat((Object)serverCtx).isNotNull();
            Truth.assertThat((Comparable)serverCtx.getDeadline()).isAtLeast((Comparable)Deadline.after((long)8L, (TimeUnit)TimeUnit.MINUTES));
        }
    }

    @Test
    public void testCallContextPropagatedInReadBatcher() throws IOException, InterruptedException, ExecutionException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).setPrimedTableIds(new String[]{"table1", "table2"}).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            this.contextInterceptor.contexts.clear();
            GrpcCallContext clientCtx = GrpcCallContext.createDefault().withTimeout(Duration.ofMinutes((long)10L));
            try (Batcher batcher = stub.newBulkReadRowsBatcher(Query.create((String)"table1"), clientCtx);){
                batcher.add((Object)ByteString.copyFromUtf8((String)"key")).get();
            }
            Context serverCtx = (Context)this.contextInterceptor.contexts.poll();
            Truth.assertThat((Object)serverCtx).isNotNull();
            Truth.assertThat((Comparable)serverCtx.getDeadline()).isAtLeast((Comparable)Deadline.after((long)8L, (TimeUnit)TimeUnit.MINUTES));
        }
    }

    private static class FakeDataService
    extends BigtableGrpc.BigtableImplBase {
        final BlockingQueue<ReadRowsRequest> requests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<PingAndWarmRequest> pingRequests = Queues.newLinkedBlockingDeque();

        private FakeDataService() {
        }

        ReadRowsRequest popLastRequest() throws InterruptedException {
            return this.requests.poll(1L, TimeUnit.SECONDS);
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            MutateRowsResponse.Builder builder = MutateRowsResponse.newBuilder();
            for (int i = 0; i < request.getEntriesCount(); ++i) {
                builder.addEntries(MutateRowsResponse.Entry.newBuilder().setIndex((long)i).build());
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            this.requests.add(request);
            responseObserver.onNext((Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setCommitRow(true).setRowKey(ByteString.copyFromUtf8((String)"a")).setFamilyName(StringValue.getDefaultInstance()).setQualifier(BytesValue.getDefaultInstance()).setValueSize(0)).build());
            responseObserver.onCompleted();
        }

        public void pingAndWarm(PingAndWarmRequest request, StreamObserver<PingAndWarmResponse> responseObserver) {
            this.pingRequests.add(request);
            responseObserver.onNext((Object)PingAndWarmResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    private static class ContextInterceptor
    implements ServerInterceptor {
        final BlockingQueue<Context> contexts = Queues.newLinkedBlockingDeque();

        private ContextInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.contexts.add(Context.current());
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }

    private static class MetadataInterceptor
    implements ServerInterceptor {
        final BlockingQueue<Metadata> headers = Queues.newLinkedBlockingDeque();

        private MetadataInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.headers.add(metadata);
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }
}

