/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.rpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Metadata;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCallHandler;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HeadersTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String TABLE_NAME = NameUtil.formatTableName((String)"fake-project", (String)"fake-instance", (String)"fake-table");
    private static final String APP_PROFILE_ID = "fake-profile";
    private static final String TEST_FIXED_HEADER_STRING = "test_fixed_header";
    private static final Metadata.Key<String> X_GOOG_REQUEST_PARAMS_KEY = Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> API_CLIENT_HEADER_KEY = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> TEST_FIXED_HEADER = Metadata.Key.of((String)"test_fixed_header", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private Server server;
    private BlockingQueue<Metadata> sentMetadata = new ArrayBlockingQueue<Metadata>(10);
    private BigtableDataClient client;

    @Before
    public void setUp() throws Exception {
        this.server = FakeServiceBuilder.create(new BindableService[]{new FakeBigtableService()}).intercept(new MetadataInterceptor()).start();
        BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID);
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{TEST_FIXED_HEADER_STRING, "test_header_value"});
        ((EnhancedBigtableStubSettings.Builder)settings.stubSettings().setHeaderProvider((HeaderProvider)headerProvider)).bulkMutateRowsSettings().setBatchingSettings(settings.stubSettings().bulkMutateRowsSettings().getBatchingSettings().toBuilder().setElementCountThreshold(Long.valueOf(1L)).build());
        this.client = BigtableDataClient.create((BigtableDataSettings)settings.build());
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
        this.server.shutdown();
    }

    @Test
    public void readRowsTest() {
        this.client.readRows(Query.create((String)TABLE_ID));
        this.verifyHeaderSent();
    }

    @Test
    public void sampleRowKeysTest() {
        this.client.sampleRowKeysAsync(TABLE_ID);
        this.verifyHeaderSent();
    }

    @Test
    public void mutateRowTest() {
        this.client.mutateRowAsync(RowMutation.create((String)TABLE_ID, (String)"fake-key").deleteRow());
        this.verifyHeaderSent();
    }

    @Test
    public void mutateRowsTest() throws InterruptedException {
        try (Batcher batcher = this.client.newBulkMutationBatcher(TABLE_ID);){
            batcher.add((Object)RowMutationEntry.create((String)"fake-key").deleteRow());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.verifyHeaderSent();
    }

    @Test
    public void checkAndMutateRowTest() {
        this.client.checkAndMutateRowAsync(ConditionalRowMutation.create((String)TABLE_ID, (String)"fake-key").then(Mutation.create().deleteRow()));
        this.verifyHeaderSent();
    }

    @Test
    public void readModifyWriteTest() {
        this.client.readModifyWriteRowAsync(ReadModifyWriteRow.create((String)TABLE_ID, (String)"fake-key").increment("cf", "q", 1L));
        this.verifyHeaderSent();
    }

    private void verifyHeaderSent() {
        Metadata metadata;
        try {
            metadata = this.sentMetadata.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        String requestParamsvalue = (String)metadata.get(X_GOOG_REQUEST_PARAMS_KEY);
        Truth.assertThat((String)requestParamsvalue).containsMatch("(^|.*&)table_name=" + TABLE_NAME + "($|&.*)");
        Truth.assertThat((String)requestParamsvalue).containsMatch("(^|.*&)app_profile_id=fake-profile($|&.*)");
        String apiClientValue = (String)metadata.get(API_CLIENT_HEADER_KEY);
        Truth.assertThat((String)apiClientValue).containsMatch("gl-java/[.\\d_]+");
        Truth.assertThat((String)apiClientValue).containsMatch("gax/[.\\d_]+");
        Truth.assertThat((String)apiClientValue).containsMatch("grpc/[.\\d_]+");
        String fixedHeader = (String)metadata.get(TEST_FIXED_HEADER);
        Truth.assertThat((String)fixedHeader).isEqualTo((Object)"test_header_value");
    }

    private static class FakeBigtableService
    extends BigtableGrpc.BigtableImplBase {
        private FakeBigtableService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            responseObserver.onCompleted();
        }

        public void sampleRowKeys(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> responseObserver) {
            responseObserver.onCompleted();
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            responseObserver.onNext((Object)MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(Status.getDefaultInstance())).build());
            responseObserver.onCompleted();
        }

        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> responseObserver) {
            responseObserver.onNext((Object)CheckAndMutateRowResponse.getDefaultInstance());
        }

        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<ReadModifyWriteRowResponse> responseObserver) {
            responseObserver.onNext((Object)ReadModifyWriteRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    private class MetadataInterceptor
    implements ServerInterceptor {
        private MetadataInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            HeadersTest.this.sentMetadata.add(metadata);
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }
}

