/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MutateRowCallableTest {
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    private UnaryCallable<MutateRowRequest, MutateRowResponse> innerCallable;
    private ArgumentCaptor<MutateRowRequest> innerMutation;
    private SettableApiFuture<MutateRowResponse> innerResult;

    @Before
    public void setUp() {
        this.innerCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        this.innerMutation = ArgumentCaptor.forClass(MutateRowRequest.class);
        this.innerResult = SettableApiFuture.create();
        Mockito.when((Object)this.innerCallable.futureCall(this.innerMutation.capture(), (ApiCallContext)Mockito.any())).thenReturn(this.innerResult);
    }

    @Test
    public void testRequestConversion() {
        MutateRowCallable callable = new MutateRowCallable(this.innerCallable, REQUEST_CONTEXT);
        RowMutation outerRequest = RowMutation.create((String)"fake-table", (String)"fake-key").setCell("fake-family", "fake-qualifier", 1000L, "fake-value");
        this.innerResult.set((Object)MutateRowResponse.getDefaultInstance());
        callable.call((Object)outerRequest);
        Truth.assertThat((Object)this.innerMutation.getValue()).isEqualTo((Object)outerRequest.toProto(REQUEST_CONTEXT));
    }
}

