/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.protobuf.ByteString;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadModifyWriteRowCallableTest {
    private final RequestContext requestContext = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    private FakeCallable inner;
    private ReadModifyWriteRowCallable callable;

    @Before
    public void setUp() {
        this.inner = new FakeCallable();
        this.callable = new ReadModifyWriteRowCallable((UnaryCallable)this.inner, this.requestContext);
    }

    @Test
    public void requestIsCorrect() {
        this.callable.futureCall((Object)ReadModifyWriteRow.create((String)"my-table", (String)"my-key").append("my-family", "", "suffix"));
        Truth.assertThat((Object)this.inner.request).isEqualTo((Object)ReadModifyWriteRowRequest.newBuilder().setTableName(NameUtil.formatTableName((String)this.requestContext.getProjectId(), (String)this.requestContext.getInstanceId(), (String)"my-table")).setAppProfileId(this.requestContext.getAppProfileId()).setRowKey(ByteString.copyFromUtf8((String)"my-key")).addRules(ReadModifyWriteRule.newBuilder().setFamilyName("my-family").setColumnQualifier(ByteString.EMPTY).setAppendValue(ByteString.copyFromUtf8((String)"suffix"))).build());
    }

    @Test
    public void responseCorrectlyTransformed() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)ReadModifyWriteRow.create((String)"my-table", (String)"my-key").append("my-family", "col", "suffix"));
        this.inner.response.set((Object)ReadModifyWriteRowResponse.newBuilder().setRow(com.google.bigtable.v2.Row.newBuilder().setKey(ByteString.copyFromUtf8((String)"my-key")).addFamilies(Family.newBuilder().setName("my-family").addColumns(Column.newBuilder().setQualifier(ByteString.copyFromUtf8((String)"col")).addCells(Cell.newBuilder().setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"suffix")))))).build());
        Truth.assertThat((Object)result.get(1L, TimeUnit.SECONDS)).isEqualTo((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"my-key"), (List)ImmutableList.of((Object)RowCell.create((String)"my-family", (ByteString)ByteString.copyFromUtf8((String)"col"), (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"suffix")))));
    }

    @Test
    public void responseSortsFamilies() throws Exception {
        ByteString col = ByteString.copyFromUtf8((String)"col1");
        ByteString value1 = ByteString.copyFromUtf8((String)"value1");
        ByteString value2 = ByteString.copyFromUtf8((String)"value2");
        ApiFuture result = this.callable.futureCall((Object)ReadModifyWriteRow.create((String)"my-table", (String)"my-key").append("my-family", "col", "suffix"));
        this.inner.response.set((Object)ReadModifyWriteRowResponse.newBuilder().setRow(com.google.bigtable.v2.Row.newBuilder().setKey(ByteString.copyFromUtf8((String)"my-key")).addFamilies(Family.newBuilder().setName("family2").addColumns(Column.newBuilder().setQualifier(col).addCells(Cell.newBuilder().setTimestampMicros(1000L).setValue(value2)))).addFamilies(Family.newBuilder().setName("family1").addColumns(Column.newBuilder().setQualifier(col).addCells(Cell.newBuilder().setTimestampMicros(1000L).setValue(value1))).build())).build());
        Truth.assertThat((Object)result.get(1L, TimeUnit.SECONDS)).isEqualTo((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"my-key"), (List)ImmutableList.of((Object)RowCell.create((String)"family1", (ByteString)col, (long)1000L, (List)ImmutableList.of(), (ByteString)value1), (Object)RowCell.create((String)"family2", (ByteString)col, (long)1000L, (List)ImmutableList.of(), (ByteString)value2))));
    }

    @Test
    public void errorIsPropagated() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)ReadModifyWriteRow.create((String)"my-table", (String)"my-key").append("my-family", "", "suffix"));
        NotFoundException expectedError = new NotFoundException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        this.inner.response.setException((Throwable)expectedError);
        Throwable actualError = null;
        try {
            result.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            actualError = e.getCause();
        }
        Truth.assertThat((Throwable)actualError).isEqualTo((Object)expectedError);
    }

    static class FakeCallable
    extends UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> {
        ReadModifyWriteRowRequest request;
        ApiCallContext callContext;
        SettableApiFuture<ReadModifyWriteRowResponse> response = SettableApiFuture.create();

        FakeCallable() {
        }

        public ApiFuture<ReadModifyWriteRowResponse> futureCall(ReadModifyWriteRowRequest request, ApiCallContext context) {
            this.request = request;
            this.callContext = context;
            return this.response;
        }
    }
}

