/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.protobuf.ByteString;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SampleRowKeysCallableTest {
    private final RequestContext requestContext = RequestContext.create((String)"my-project", (String)"my-instance", (String)"my-profile");
    private FakeCallable inner;
    private SampleRowKeysCallable callable;

    @Before
    public void setUp() {
        this.inner = new FakeCallable();
        this.callable = new SampleRowKeysCallable((UnaryCallable)this.inner, this.requestContext);
    }

    @Test
    public void requestIsCorrect() {
        this.callable.futureCall((Object)"my-table");
        Truth.assertThat((Object)this.inner.request).isEqualTo((Object)SampleRowKeysRequest.newBuilder().setTableName(NameUtil.formatTableName((String)this.requestContext.getProjectId(), (String)this.requestContext.getInstanceId(), (String)"my-table")).setAppProfileId(this.requestContext.getAppProfileId()).build());
    }

    @Test
    public void responseCorrectlyTransformed() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"my-table");
        this.inner.response.set((Object)ImmutableList.of((Object)SampleRowKeysResponse.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"key1")).setOffsetBytes(100L).build(), (Object)SampleRowKeysResponse.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"")).setOffsetBytes(1000L).build()));
        Truth.assertThat((Iterable)((Iterable)result.get(1L, TimeUnit.SECONDS))).isEqualTo((Object)ImmutableList.of((Object)KeyOffset.create((ByteString)ByteString.copyFromUtf8((String)"key1"), (long)100L), (Object)KeyOffset.create((ByteString)ByteString.EMPTY, (long)1000L)));
    }

    @Test
    public void errorIsPropagated() throws Exception {
        ApiFuture result = this.callable.futureCall((Object)"my-table");
        NotFoundException expectedError = new NotFoundException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.NOT_FOUND), false);
        this.inner.response.setException((Throwable)expectedError);
        Throwable actualError = null;
        try {
            result.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            actualError = e.getCause();
        }
        Truth.assertThat((Throwable)actualError).isEqualTo((Object)expectedError);
    }

    static class FakeCallable
    extends UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> {
        SampleRowKeysRequest request;
        ApiCallContext callContext;
        SettableApiFuture<List<SampleRowKeysResponse>> response = SettableApiFuture.create();

        FakeCallable() {
        }

        public ApiFuture<List<SampleRowKeysResponse>> futureCall(SampleRowKeysRequest request, ApiCallContext context) {
            this.request = request;
            this.callContext = context;
            return this.response;
        }
    }
}

