/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnavailableException;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViewConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.cloud.bigtable.data.v2.stub.metrics.StatsTestUtils;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ForwardingServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Metadata;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCallHandler;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import io.opencensus.impl.stats.StatsComponentImpl;
import io.opencensus.stats.StatsComponent;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableTracerCallableTest {
    private Server server;
    private Server serverNoHeader;
    private FakeService fakeService = new FakeService();
    private final StatsComponent localStats = new StatsComponentImpl();
    private EnhancedBigtableStub stub;
    private EnhancedBigtableStub noHeaderStub;
    private int attempts;
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String APP_PROFILE_ID = "default";
    private static final String TABLE_ID = "fake-table";
    private static final long WAIT_FOR_METRICS_TIME_MS = 1000L;
    private AtomicInteger fakeServerTiming;

    @Before
    public void setUp() throws Exception {
        RpcViews.registerBigtableClientGfeViews((ViewManager)this.localStats.getViewManager());
        this.fakeServerTiming = new AtomicInteger(new Random().nextInt(1000) + 1);
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata headers) {
                        headers.put(Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.format("gfet4t7; dur=%d", BigtableTracerCallableTest.this.fakeServerTiming.get()));
                        super.sendHeaders(headers);
                    }
                }, metadata);
            }
        }).start();
        BigtableDataSettings settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).build();
        EnhancedBigtableStubSettings stubSettings = EnhancedBigtableStub.finalizeSettings((EnhancedBigtableStubSettings)settings.getStubSettings(), (Tagger)Tags.getTagger(), (StatsRecorder)this.localStats.getStatsRecorder());
        this.attempts = stubSettings.readRowsSettings().getRetrySettings().getMaxAttempts();
        this.stub = new EnhancedBigtableStub(stubSettings, ClientContext.create((StubSettings)stubSettings));
        this.serverNoHeader = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).start();
        BigtableDataSettings noHeaderSettings = BigtableDataSettings.newBuilderForEmulator((int)this.serverNoHeader.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).build();
        EnhancedBigtableStubSettings noHeaderStubSettings = EnhancedBigtableStub.finalizeSettings((EnhancedBigtableStubSettings)noHeaderSettings.getStubSettings(), (Tagger)Tags.getTagger(), (StatsRecorder)this.localStats.getStatsRecorder());
        this.noHeaderStub = new EnhancedBigtableStub(noHeaderStubSettings, ClientContext.create((StubSettings)noHeaderStubSettings));
    }

    @After
    public void tearDown() {
        this.stub.close();
        this.noHeaderStub.close();
        this.server.shutdown();
        this.serverNoHeader.shutdown();
    }

    @Test
    public void testGFELatencyMetricReadRows() throws InterruptedException {
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID));
        Thread.sleep(1000L);
        long latency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)latency).isEqualTo((Object)this.fakeServerTiming.get());
    }

    @Test
    public void testGFELatencyMetricMutateRow() throws InterruptedException {
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE_ID, (String)"fake-key"));
        Thread.sleep(1000L);
        long latency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.MutateRow"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)latency).isEqualTo((Object)this.fakeServerTiming.get());
    }

    @Test
    public void testGFELatencyMetricMutateRows() throws InterruptedException {
        BulkMutation mutations = BulkMutation.create((String)TABLE_ID).add("key", Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value"));
        this.stub.bulkMutateRowsCallable().call((Object)mutations);
        Thread.sleep(1000L);
        long latency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.MutateRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)latency).isEqualTo((Object)this.fakeServerTiming.get());
    }

    @Test
    public void testGFELatencySampleRowKeys() throws InterruptedException {
        this.stub.sampleRowKeysCallable().call((Object)TABLE_ID);
        Thread.sleep(1000L);
        long latency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.SampleRowKeys"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)latency).isEqualTo((Object)this.fakeServerTiming.get());
    }

    @Test
    public void testGFELatencyCheckAndMutateRow() throws InterruptedException {
        ConditionalRowMutation mutation = ConditionalRowMutation.create((String)TABLE_ID, (String)"fake-key").then(Mutation.create().setCell("fake-family", "fake-qualifier", "fake-value"));
        this.stub.checkAndMutateRowCallable().call((Object)mutation);
        Thread.sleep(1000L);
        long latency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.CheckAndMutateRow"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)latency).isEqualTo((Object)this.fakeServerTiming.get());
    }

    @Test
    public void testGFELatencyReadModifyWriteRow() throws InterruptedException {
        ReadModifyWriteRow request = ReadModifyWriteRow.create((String)TABLE_ID, (String)"fake-key").append("fake-family", "fake-qualifier", "suffix");
        this.stub.readModifyWriteRowCallable().call((Object)request);
        Thread.sleep(1000L);
        long latency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadModifyWriteRow"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)latency).isEqualTo((Object)this.fakeServerTiming.get());
    }

    @Test
    public void testGFEMissingHeaderMetric() throws InterruptedException {
        int i;
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID));
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE_ID, (String)"key"));
        Thread.sleep(1000L);
        long mutateRowMissingCount = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.MutateRow"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        long readRowsMissingCount = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Thread.sleep(1000L);
        Truth.assertThat((Long)mutateRowMissingCount).isEqualTo((Object)0);
        Truth.assertThat((Long)readRowsMissingCount).isEqualTo((Object)0);
        int readRowsCalls = new Random().nextInt(10) + 1;
        int mutateRowCalls = new Random().nextInt(10) + 1;
        for (i = 0; i < mutateRowCalls; ++i) {
            this.noHeaderStub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE_ID, (String)("fake-key" + i)));
        }
        for (i = 0; i < readRowsCalls; ++i) {
            this.noHeaderStub.readRowsCallable().call((Object)Query.create((String)TABLE_ID));
        }
        Thread.sleep(1000L);
        mutateRowMissingCount = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.MutateRow"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        readRowsMissingCount = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)mutateRowMissingCount).isEqualTo((Object)mutateRowCalls);
        Truth.assertThat((Long)readRowsMissingCount).isEqualTo((Object)readRowsCalls);
    }

    @Test
    public void testMetricsWithErrorResponse() throws InterruptedException {
        try {
            this.stub.readRowsCallable().call((Object)Query.create((String)"random-table-id")).iterator().next();
            Assert.fail((String)"readrows should throw exception");
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e).isInstanceOf(UnavailableException.class);
        }
        Thread.sleep(1000L);
        long missingCount = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_GFE_HEADER_MISSING_COUNT_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"UNAVAILABLE")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)missingCount).isEqualTo((Object)this.attempts);
    }

    private class FakeService
    extends BigtableGrpc.BigtableImplBase {
        private final String defaultTableName = NameUtil.formatTableName((String)"fake-project", (String)"fake-instance", (String)"fake-table");

        private FakeService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> observer) {
            if (!request.getTableName().equals(this.defaultTableName)) {
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            observer.onNext((Object)ReadRowsResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> observer) {
            observer.onNext((Object)MutateRowResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> observer) {
            observer.onNext((Object)MutateRowsResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void sampleRowKeys(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> observer) {
            observer.onNext((Object)SampleRowKeysResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> observer) {
            observer.onNext((Object)CheckAndMutateRowResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<ReadModifyWriteRowResponse> observer) {
            observer.onNext((Object)ReadModifyWriteRowResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }
}

