/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.client.util.Lists;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.ResponseParams;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.cloud.bigtable.stats.StatsRecorderWrapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ForwardingServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Metadata;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCallHandler;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.ServerCallStreamObserver;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.base.Stopwatch;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Range;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class BuiltinMetricsTracerTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String APP_PROFILE_ID = "default";
    private static final String TABLE_ID = "fake-table";
    private static final String ZONE = "us-west-1";
    private static final String CLUSTER = "cluster-0";
    private static final long FAKE_SERVER_TIMING = 50L;
    private static final long SERVER_LATENCY = 100L;
    private static final long APPLICATION_LATENCY = 200L;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private final FakeService fakeService = new FakeService();
    private Server server;
    private EnhancedBigtableStub stub;
    @Mock
    private BuiltinMetricsTracerFactory mockFactory;
    @Mock
    private StatsRecorderWrapper statsRecorderWrapper;
    @Captor
    private ArgumentCaptor<String> status;
    @Captor
    private ArgumentCaptor<String> tableId;
    @Captor
    private ArgumentCaptor<String> zone;
    @Captor
    private ArgumentCaptor<String> cluster;

    @Before
    public void setUp() throws Exception {
        ServerInterceptor trailersInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata headers) {
                        headers.put(Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.format("gfet4t7; dur=%d", 50L));
                        ResponseParams params = ResponseParams.newBuilder().setZoneId(BuiltinMetricsTracerTest.ZONE).setClusterId(BuiltinMetricsTracerTest.CLUSTER).build();
                        byte[] byteArray = params.toByteArray();
                        headers.put(Util.METADATA_KEY, (Object)byteArray);
                        super.sendHeaders(headers);
                    }
                }, metadata);
            }
        };
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(trailersInterceptor).start();
        BigtableDataSettings settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).build();
        EnhancedBigtableStubSettings.Builder stubSettingsBuilder = settings.getStubSettings().toBuilder();
        stubSettingsBuilder.mutateRowSettings().retrySettings().setInitialRetryDelay(Duration.ofMillis((long)200L));
        stubSettingsBuilder.setTracerFactory((ApiTracerFactory)this.mockFactory);
        EnhancedBigtableStubSettings stubSettings = stubSettingsBuilder.build();
        this.stub = new EnhancedBigtableStub(stubSettings, ClientContext.create((StubSettings)stubSettings));
    }

    @After
    public void tearDown() {
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void testOperationLatencies() {
        Mockito.when((Object)this.mockFactory.newTracer((ApiTracer)ArgumentMatchers.any(), (SpanName)ArgumentMatchers.any(), (ApiTracerFactory.OperationType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new BuiltinMetricsTracer(ApiTracerFactory.OperationType.ServerStreaming, SpanName.of((String)"Bigtable", (String)"ReadRows"), this.statsRecorderWrapper));
        ArgumentCaptor operationLatency = ArgumentCaptor.forClass(Long.class);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Lists.newArrayList((Iterator)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)).iterator());
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper)).putOperationLatencies(((Long)operationLatency.capture()).longValue());
        Truth.assertThat((Long)((Long)operationLatency.getValue())).isIn(Range.closed((Comparable)Long.valueOf(100L), (Comparable)Long.valueOf(elapsed)));
    }

    @Test
    public void testGfeMetrics() {
        Mockito.when((Object)this.mockFactory.newTracer((ApiTracer)ArgumentMatchers.any(), (SpanName)ArgumentMatchers.any(), (ApiTracerFactory.OperationType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new BuiltinMetricsTracer(ApiTracerFactory.OperationType.ServerStreaming, SpanName.of((String)"Bigtable", (String)"ReadRows"), this.statsRecorderWrapper));
        ArgumentCaptor gfeLatency = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor gfeMissingHeaders = ArgumentCaptor.forClass(Long.class);
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)));
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper)).putGfeLatencies(((Long)gfeLatency.capture()).longValue());
        Truth.assertThat((Long)((Long)gfeLatency.getValue())).isEqualTo((Object)50L);
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper, (VerificationMode)Mockito.times((int)this.fakeService.getAttemptCounter().get()))).putGfeMissingHeaders(((Long)gfeMissingHeaders.capture()).longValue());
        Truth.assertThat((Long)((Long)gfeMissingHeaders.getValue())).isEqualTo((Object)1);
    }

    @Test
    public void testReadRowsApplicationLatencyWithAutoFlowControl() throws Exception {
        Mockito.when((Object)this.mockFactory.newTracer((ApiTracer)ArgumentMatchers.any(), (SpanName)ArgumentMatchers.any(), (ApiTracerFactory.OperationType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new BuiltinMetricsTracer(ApiTracerFactory.OperationType.ServerStreaming, SpanName.of((String)"Bigtable", (String)"ReadRows"), this.statsRecorderWrapper));
        ArgumentCaptor applicationLatency = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor operationLatency = ArgumentCaptor.forClass(Long.class);
        final SettableApiFuture future = SettableApiFuture.create();
        final AtomicInteger counter = new AtomicInteger(0);
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID), (ResponseObserver)new ResponseObserver<Row>(){

            public void onStart(StreamController streamController) {
            }

            public void onResponse(Row row) {
                try {
                    counter.getAndIncrement();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void onError(Throwable throwable) {
                future.setException(throwable);
            }

            public void onComplete() {
                future.set(null);
            }
        });
        future.get();
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper)).putApplicationLatencies(((Long)applicationLatency.capture()).longValue());
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper)).putOperationLatencies(((Long)operationLatency.capture()).longValue());
        Truth.assertThat((Integer)counter.get()).isEqualTo((Object)this.fakeService.getResponseCounter().get());
        Truth.assertThat((Long)((Long)applicationLatency.getValue())).isAtLeast((Comparable)Long.valueOf(200L * (long)counter.get()));
        Truth.assertThat((Long)((Long)applicationLatency.getValue())).isAtMost((Comparable)Long.valueOf((Long)operationLatency.getValue() - 100L));
    }

    @Test
    public void testReadRowsApplicationLatencyWithManualFlowControl() throws Exception {
        Mockito.when((Object)this.mockFactory.newTracer((ApiTracer)ArgumentMatchers.any(), (SpanName)ArgumentMatchers.any(), (ApiTracerFactory.OperationType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new BuiltinMetricsTracer(ApiTracerFactory.OperationType.ServerStreaming, SpanName.of((String)"Bigtable", (String)"ReadRows"), this.statsRecorderWrapper));
        ArgumentCaptor applicationLatency = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor operationLatency = ArgumentCaptor.forClass(Long.class);
        int counter = 0;
        Iterator rows = this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)).iterator();
        while (rows.hasNext()) {
            ++counter;
            Thread.sleep(200L);
            rows.next();
        }
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper)).putApplicationLatencies(((Long)applicationLatency.capture()).longValue());
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper)).putOperationLatencies(((Long)operationLatency.capture()).longValue());
        Truth.assertThat((Integer)counter).isEqualTo((Object)this.fakeService.getResponseCounter().get());
        Truth.assertThat((Long)((Long)applicationLatency.getValue())).isAtLeast((Comparable)Long.valueOf(200L * (long)(counter - 1) - 100L));
        Truth.assertThat((Long)((Long)applicationLatency.getValue())).isAtMost((Comparable)Long.valueOf((Long)operationLatency.getValue() - 100L));
    }

    @Test
    public void testRetryCount() {
        Mockito.when((Object)this.mockFactory.newTracer((ApiTracer)ArgumentMatchers.any(), (SpanName)ArgumentMatchers.any(), (ApiTracerFactory.OperationType)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new BuiltinMetricsTracer(ApiTracerFactory.OperationType.ServerStreaming, SpanName.of((String)"Bigtable", (String)"ReadRows"), this.statsRecorderWrapper));
        ArgumentCaptor retryCount = ArgumentCaptor.forClass(Integer.class);
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE_ID, (String)"random-row").setCell("cf", "q", "value"));
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper, (VerificationMode)Mockito.timeout((long)20L))).putRetryCount(((Integer)retryCount.capture()).intValue());
        Truth.assertThat((Integer)((Integer)retryCount.getValue())).isEqualTo((Object)(this.fakeService.getAttemptCounter().get() - 1));
    }

    @Test
    public void testMutateRowAttempts() {
        Mockito.when((Object)this.mockFactory.newTracer((ApiTracer)ArgumentMatchers.any(), (SpanName)ArgumentMatchers.any(), (ApiTracerFactory.OperationType)ArgumentMatchers.any())).thenReturn((Object)new BuiltinMetricsTracer(ApiTracerFactory.OperationType.Unary, SpanName.of((String)"Bigtable", (String)"MutateRow"), this.statsRecorderWrapper));
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE_ID, (String)"random-row").setCell("cf", "q", "value"));
        ((StatsRecorderWrapper)Mockito.verify((Object)this.statsRecorderWrapper, (VerificationMode)Mockito.timeout((long)50L).times(this.fakeService.getAttemptCounter().get()))).recordAttempt((String)this.status.capture(), (String)this.tableId.capture(), (String)this.zone.capture(), (String)this.cluster.capture());
        Truth.assertThat((Iterable)this.zone.getAllValues()).containsExactly(new Object[]{"global", "global", ZONE});
        Truth.assertThat((Iterable)this.cluster.getAllValues()).containsExactly(new Object[]{"unspecified", "unspecified", CLUSTER});
        Truth.assertThat((Iterable)this.status.getAllValues()).containsExactly(new Object[]{"UNAVAILABLE", "UNAVAILABLE", "OK"});
    }

    private static class FakeService
    extends BigtableGrpc.BigtableImplBase {
        private final AtomicInteger attemptCounter = new AtomicInteger(0);
        private final AtomicInteger responseCounter = new AtomicInteger(0);
        private final Iterator<ReadRowsResponse> source = FakeService.createFakeResponse().listIterator();

        private FakeService() {
        }

        static List<ReadRowsResponse> createFakeResponse() {
            ArrayList<ReadRowsResponse> responses = new ArrayList<ReadRowsResponse>();
            for (int i = 0; i < 4; ++i) {
                responses.add(ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)("fake-key-" + i))).setFamilyName(StringValue.of((String)"cf")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"q"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)String.join((CharSequence)"", Collections.nCopies(0x100000, "A")))).setCommitRow(true)).build());
            }
            return responses;
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            AtomicBoolean done = new AtomicBoolean();
            ServerCallStreamObserver target = (ServerCallStreamObserver)responseObserver;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.attemptCounter.getAndIncrement() == 0) {
                target.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            target.setOnReadyHandler(() -> {
                while (target.isReady() && this.source.hasNext()) {
                    this.responseCounter.getAndIncrement();
                    target.onNext((Object)this.source.next());
                }
                if (!this.source.hasNext() && done.compareAndSet(false, true)) {
                    target.onCompleted();
                }
            });
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            if (this.attemptCounter.getAndIncrement() < 2) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public AtomicInteger getAttemptCounter() {
            return this.attemptCounter;
        }

        public AtomicInteger getResponseCounter() {
            return this.responseCounter;
        }
    }
}

