/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracer;
import com.google.cloud.bigtable.misc_utilities.MethodComparator;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class CompositeTracerTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private ApiTracer child1;
    @Mock
    private ApiTracer child2;
    @Mock
    private BigtableTracer child3;
    @Mock
    private BigtableTracer child4;
    private CompositeTracer compositeTracer;

    @Before
    public void setup() {
        this.compositeTracer = new CompositeTracer((List)ImmutableList.of((Object)this.child1, (Object)this.child2, (Object)this.child3, (Object)this.child4));
    }

    @Test
    public void testInScope() {
        ApiTracer.Scope scope1 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child1.inScope()).thenReturn((Object)scope1);
        ApiTracer.Scope scope2 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child2.inScope()).thenReturn((Object)scope2);
        ApiTracer.Scope scope3 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child3.inScope()).thenReturn((Object)scope3);
        ApiTracer.Scope scope4 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child4.inScope()).thenReturn((Object)scope4);
        ApiTracer.Scope parentScope = this.compositeTracer.inScope();
        parentScope.close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope1, (VerificationMode)Mockito.times((int)1))).close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope2, (VerificationMode)Mockito.times((int)1))).close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope3, (VerificationMode)Mockito.times((int)1))).close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope4, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testOperationSucceeded() {
        this.compositeTracer.operationSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationCancelled() {
        this.compositeTracer.operationCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testOperationFailed() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.operationFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
    }

    @Test
    public void testConnectionSelected() {
        this.compositeTracer.connectionSelected("connection-one");
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
    }

    @Test
    public void testAttemptStarted() {
        ReadRowsRequest request = ReadRowsRequest.getDefaultInstance();
        this.compositeTracer.attemptStarted((Object)request, 3);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
    }

    @Test
    public void testAttemptSucceeded() {
        this.compositeTracer.attemptSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
    }

    @Test
    public void testAttemptCancelled() {
        this.compositeTracer.attemptCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
    }

    @Test
    public void testAttemptFailed() {
        RuntimeException error = new RuntimeException();
        Duration delay = Duration.ofMillis((long)10L);
        this.compositeTracer.attemptFailed((Throwable)error, delay);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptFailed((Throwable)error, delay);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptFailed((Throwable)error, delay);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptFailed((Throwable)error, delay);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptFailed((Throwable)error, delay);
    }

    @Test
    public void testAttemptFailedRetriesExhausted() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.attemptFailedRetriesExhausted((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
    }

    @Test
    public void testAttemptPermanentFailure() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.attemptPermanentFailure((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
    }

    @Test
    public void testLroStartFailed() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.lroStartFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
    }

    @Test
    public void testLroStartSucceeded() {
        this.compositeTracer.lroStartSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
    }

    @Test
    public void testResponseReceived() {
        this.compositeTracer.responseReceived();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).responseReceived();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).responseReceived();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).responseReceived();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).responseReceived();
    }

    @Test
    public void testRequestSent() {
        this.compositeTracer.requestSent();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).requestSent();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).requestSent();
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).requestSent();
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).requestSent();
    }

    @Test
    public void testBatchRequestSent() {
        this.compositeTracer.batchRequestSent(2L, 20L);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
    }

    @Test
    public void testGetAttempt() {
        this.compositeTracer.attemptStarted(2);
        Assert.assertEquals((long)2L, (long)this.compositeTracer.getAttempt());
    }

    @Test
    public void testRecordGfeLatency() {
        StatusRuntimeException t = new StatusRuntimeException(Status.UNAVAILABLE);
        this.compositeTracer.recordGfeMetadata(Long.valueOf(20L), (Throwable)t);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).recordGfeMetadata(Long.valueOf(20L), (Throwable)t);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).recordGfeMetadata(Long.valueOf(20L), (Throwable)t);
    }

    @Test
    public void testBatchRequestThrottled() {
        this.compositeTracer.batchRequestThrottled(5L);
        ((BigtableTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).batchRequestThrottled(5L);
        ((BigtableTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).batchRequestThrottled(5L);
    }

    @Test
    public void testMethodsOverride() {
        Object[] baseMethods = BigtableTracer.class.getDeclaredMethods();
        Method[] compositeTracerMethods = CompositeTracer.class.getDeclaredMethods();
        Truth.assertThat(Arrays.asList(compositeTracerMethods)).comparingElementsUsing(MethodComparator.METHOD_CORRESPONDENCE).containsAtLeastElementsIn(baseMethods);
    }
}

