/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Metadata;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Server;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCall;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerCallHandler;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ServerInterceptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Queues;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StatsHeadersCallableTest {
    private Server server;
    private FakeService fakeService = new FakeService();
    private EnhancedBigtableStub stub;
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String APP_PROFILE_ID = "default";
    private static final String TABLE_ID = "fake-table";
    private final int attemptCounts = 3;
    private MetadataInterceptor metadataInterceptor;

    @Before
    public void setUp() throws Exception {
        this.metadataInterceptor = new MetadataInterceptor();
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(this.metadataInterceptor).start();
        EnhancedBigtableStubSettings settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).build().getStubSettings();
        this.stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);
    }

    @After
    public void tearDown() {
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void testReadRowsHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID).rowKey("key")).iterator().next();
        this.verifyHeaders(3, startTimestamp);
    }

    @Test
    public void testReadRowHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.readRowCallable().futureCall((Object)Query.create((String)TABLE_ID).rowKey("key")).get();
        this.verifyHeaders(3, startTimestamp);
    }

    @Test
    public void testMutateRowsHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.bulkMutateRowsCallable().futureCall((Object)BulkMutation.create((String)TABLE_ID).add(RowMutationEntry.create((String)"key"))).get();
        this.verifyHeaders(3, startTimestamp);
    }

    @Test
    public void testMutateRowHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.mutateRowCallable().futureCall((Object)RowMutation.create((String)TABLE_ID, (String)"key").setCell("f", "q", "value")).get();
        this.verifyHeaders(3, startTimestamp);
    }

    @Test
    public void testSampleRowKeysHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        ((List)this.stub.sampleRowKeysCallable().call((Object)TABLE_ID)).get(0);
        this.verifyHeaders(3, startTimestamp);
    }

    @Test
    public void testCheckAndMutateHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.checkAndMutateRowCallable().call((Object)ConditionalRowMutation.create((String)TABLE_ID, (String)"key").then(Mutation.create().setCell("f", "q", "value")));
        this.verifyHeaders(1, startTimestamp);
    }

    @Test
    public void testReadModifyWriteHeaders() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.readModifyWriteRowCallable().call((Object)ReadModifyWriteRow.create((String)TABLE_ID, (String)"key").append("f", "q", "value"));
        this.verifyHeaders(1, startTimestamp);
    }

    @Test
    public void testMultipleRequests() throws Exception {
        long startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID).rowKey("key")).iterator().next();
        this.verifyHeaders(3, startTimestamp);
        startTimestamp = System.currentTimeMillis() * 1000L;
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID).rowKey("key")).iterator().next();
        this.verifyHeaders(1, startTimestamp);
    }

    private void verifyHeaders(int expectedAttemptCounts, long startTimestamp) throws Exception {
        Truth.assertThat(this.metadataInterceptor.headers).hasSize(expectedAttemptCounts);
        long timestamp = startTimestamp;
        for (int i = 0; i < expectedAttemptCounts; ++i) {
            Metadata headers = this.metadataInterceptor.headers.take();
            String attemptCount = (String)headers.get(Util.ATTEMPT_HEADER_KEY);
            Truth.assertThat((String)attemptCount).isNotNull();
            Truth.assertThat((Integer)Integer.valueOf(attemptCount)).isEqualTo((Object)i);
            String clientTimeStr = (String)headers.get(Util.ATTEMPT_EPOCH_KEY);
            Truth.assertThat((String)clientTimeStr).isNotNull();
            long clientTime = Long.valueOf(clientTimeStr);
            Truth.assertThat((Long)clientTime).isAtLeast((Comparable)Long.valueOf(timestamp));
            timestamp = clientTime;
        }
    }

    private class FakeService
    extends BigtableGrpc.BigtableImplBase {
        AtomicInteger callCount = new AtomicInteger(0);

        private FakeService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> observer) {
            if (this.callCount.get() < 2) {
                this.callCount.incrementAndGet();
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            observer.onNext((Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setCommitRow(true).setRowKey(ByteString.copyFromUtf8((String)"a")).setFamilyName(StringValue.getDefaultInstance()).setQualifier(BytesValue.getDefaultInstance()).setValueSize(0)).build());
            observer.onCompleted();
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> observer) {
            if (this.callCount.get() < 2) {
                this.callCount.incrementAndGet();
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            observer.onNext((Object)MutateRowResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> observer) {
            if (this.callCount.get() < 2) {
                this.callCount.incrementAndGet();
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            observer.onNext((Object)MutateRowsResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void sampleRowKeys(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> observer) {
            if (this.callCount.get() < 2) {
                this.callCount.incrementAndGet();
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            observer.onNext((Object)SampleRowKeysResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> observer) {
            observer.onNext((Object)CheckAndMutateRowResponse.getDefaultInstance());
            observer.onCompleted();
        }

        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<ReadModifyWriteRowResponse> observer) {
            observer.onNext((Object)ReadModifyWriteRowResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    private static class MetadataInterceptor
    implements ServerInterceptor {
        final BlockingQueue<Metadata> headers = Queues.newLinkedBlockingDeque();

        private MetadataInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.headers.add(metadata);
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }
}

