/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Context;
import cz.o2.proxima.internal.shaded.com.google.common.base.Function;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Iterators;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Maps;
import io.opencensus.common.Scope;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.Measure;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.StatsComponent;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.unsafe.ContextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class StatsTestUtils {
    private StatsTestUtils() {
    }

    private static ImmutableMap<TagKey, TagValue> getTags(TagContext tags) {
        return tags instanceof FakeTagContext ? ((FakeTagContext)tags).getTags() : ImmutableMap.of();
    }

    public static long getAggregationValueAsLong(StatsComponent stats, View view, ImmutableMap<TagKey, TagValue> tags, String projectId, String instanceId, String appProfileId) {
        ViewData viewData = stats.getViewManager().getView(view.getName());
        Map aggregationMap = Objects.requireNonNull(viewData).getAggregationMap();
        ArrayList<Object> tagValues = new ArrayList<Object>();
        for (TagKey column : view.getColumns()) {
            if (RpcMeasureConstants.BIGTABLE_PROJECT_ID == column) {
                tagValues.add(TagValue.create((String)projectId));
                continue;
            }
            if (RpcMeasureConstants.BIGTABLE_INSTANCE_ID == column) {
                tagValues.add(TagValue.create((String)instanceId));
                continue;
            }
            if (RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID == column) {
                tagValues.add(TagValue.create((String)appProfileId));
                continue;
            }
            tagValues.add(tags.get((Object)column));
        }
        AggregationData aggregationData = (AggregationData)aggregationMap.get(tagValues);
        return (Long)aggregationData.match((io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData.SumDataDouble, Long>(){

            public Long apply(AggregationData.SumDataDouble arg) {
                return (long)arg.getSum();
            }
        }, (io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData.SumDataLong, Long>(){

            public Long apply(AggregationData.SumDataLong arg) {
                return arg.getSum();
            }
        }, (io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData.CountData, Long>(){

            public Long apply(AggregationData.CountData arg) {
                return arg.getCount();
            }
        }, (io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData.DistributionData, Long>(){

            public Long apply(AggregationData.DistributionData arg) {
                return (long)arg.getMean();
            }
        }, (io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData.LastValueDataDouble, Long>(){

            public Long apply(AggregationData.LastValueDataDouble arg) {
                return (long)arg.getLastValue();
            }
        }, (io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData.LastValueDataLong, Long>(){

            public Long apply(AggregationData.LastValueDataLong arg) {
                return arg.getLastValue();
            }
        }, (io.opencensus.common.Function)new io.opencensus.common.Function<AggregationData, Long>(){

            public Long apply(AggregationData arg) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static class FakeTagContextBuilder
    extends TagContextBuilder {
        private final Map<TagKey, TagValue> tagsBuilder = Maps.newHashMap();

        private FakeTagContextBuilder(Map<TagKey, TagValue> tags) {
            this.tagsBuilder.putAll(tags);
        }

        public TagContextBuilder put(TagKey key, TagValue value) {
            this.tagsBuilder.put(key, value);
            return this;
        }

        public TagContextBuilder remove(TagKey key) {
            this.tagsBuilder.remove(key);
            return this;
        }

        public TagContext build() {
            FakeTagContext context = new FakeTagContext(ImmutableMap.copyOf(this.tagsBuilder));
            return context;
        }

        public Scope buildScoped() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeTagContext
    extends TagContext {
        private static final FakeTagContext EMPTY = new FakeTagContext((ImmutableMap<TagKey, TagValue>)ImmutableMap.of());
        private static final TagMetadata METADATA_PROPAGATING = TagMetadata.create((TagMetadata.TagTtl)TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
        private final ImmutableMap<TagKey, TagValue> tags;

        private FakeTagContext(ImmutableMap<TagKey, TagValue> tags) {
            this.tags = tags;
        }

        public ImmutableMap<TagKey, TagValue> getTags() {
            return this.tags;
        }

        public String toString() {
            return "[tags=" + this.tags + "]";
        }

        protected Iterator<Tag> getIterator() {
            return Iterators.transform((Iterator)this.tags.entrySet().iterator(), (Function)new Function<Map.Entry<TagKey, TagValue>, Tag>(){

                public Tag apply(@Nullable Map.Entry<TagKey, TagValue> entry) {
                    return Tag.create((TagKey)entry.getKey(), (TagValue)entry.getValue(), (TagMetadata)METADATA_PROPAGATING);
                }
            });
        }
    }

    public static final class FakeStatsRecord
    extends MeasureMap {
        private final BlockingQueue<MetricsRecord> recordSink;
        public final Map<Measure, Number> metrics = Maps.newHashMap();

        private FakeStatsRecord(FakeStatsRecorder statsRecorder) {
            this.recordSink = statsRecorder.getCurrentRecordSink();
        }

        public MeasureMap put(Measure.MeasureDouble measure, double value) {
            this.metrics.put((Measure)measure, value);
            return this;
        }

        public MeasureMap put(Measure.MeasureLong measure, long value) {
            this.metrics.put((Measure)measure, value);
            return this;
        }

        public void record(TagContext tags) {
            this.recordSink.add(new MetricsRecord(StatsTestUtils.getTags(tags), ImmutableMap.copyOf(this.metrics)));
        }

        public void record() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeTagger
    extends Tagger {
        public FakeTagContext empty() {
            return FakeTagContext.EMPTY;
        }

        public TagContext getCurrentTagContext() {
            return ContextUtils.getValue((Context)Context.current());
        }

        public TagContextBuilder emptyBuilder() {
            return new FakeTagContextBuilder((Map)ImmutableMap.of());
        }

        public FakeTagContextBuilder toBuilder(TagContext tags) {
            return new FakeTagContextBuilder((Map)StatsTestUtils.getTags(tags));
        }

        public TagContextBuilder currentBuilder() {
            throw new UnsupportedOperationException();
        }

        public Scope withTagContext(TagContext tags) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeStatsRecorder
    extends StatsRecorder {
        private BlockingQueue<MetricsRecord> records;

        public FakeStatsRecorder() {
            this.rolloverRecords();
        }

        public MeasureMap newMeasureMap() {
            return new FakeStatsRecord(this);
        }

        public MetricsRecord pollRecord() {
            return (MetricsRecord)this.getCurrentRecordSink().poll();
        }

        public MetricsRecord pollRecord(long timeout, TimeUnit unit) throws InterruptedException {
            return this.getCurrentRecordSink().poll(timeout, unit);
        }

        public synchronized void rolloverRecords() {
            this.records = new LinkedBlockingQueue<MetricsRecord>();
        }

        private synchronized BlockingQueue<MetricsRecord> getCurrentRecordSink() {
            return this.records;
        }
    }

    public static class MetricsRecord {
        public final ImmutableMap<TagKey, TagValue> tags;
        public final ImmutableMap<Measure, Number> metrics;

        private MetricsRecord(ImmutableMap<TagKey, TagValue> tags, ImmutableMap<Measure, Number> metrics) {
            this.tags = tags;
            this.metrics = metrics;
        }

        @Nullable
        public Double getMetric(Measure measure) {
            for (Map.Entry m : this.metrics.entrySet()) {
                if (!((Measure)m.getKey()).equals(measure)) continue;
                Number value = (Number)m.getValue();
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Long) {
                    return (double)((Long)value);
                }
                throw new AssertionError((Object)("Unexpected measure value type: " + value.getClass().getName()));
            }
            return null;
        }

        public long getMetricAsLongOrFail(Measure measure) {
            Double doubleValue = this.getMetric(measure);
            Preconditions.checkNotNull((Object)doubleValue, (String)"Measure not found: %s", (Object)measure.getName());
            long longValue = (long)(Math.abs(doubleValue) + 1.0E-4);
            if (doubleValue < 0.0) {
                longValue = -longValue;
            }
            return longValue;
        }
    }
}

