/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import cz.o2.proxima.internal.shaded.com.google.common.util.concurrent.Futures;
import io.opencensus.tags.TagValue;
import java.util.concurrent.Future;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UtilTest {
    @Test
    public void testOk() {
        TagValue tagValue = TagValue.create((String)Util.extractStatus((Throwable)null));
        Truth.assertThat((String)tagValue.asString()).isEqualTo((Object)"OK");
    }

    @Test
    public void testOkFuture() {
        TagValue tagValue = Util.extractStatusFromFuture((Future)Futures.immediateFuture(null));
        Truth.assertThat((String)tagValue.asString()).isEqualTo((Object)"OK");
    }

    @Test
    public void testError() {
        DeadlineExceededException error = new DeadlineExceededException("Deadline exceeded", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), true);
        TagValue tagValue = TagValue.create((String)Util.extractStatus((Throwable)error));
        Truth.assertThat((String)tagValue.asString()).isEqualTo((Object)"DEADLINE_EXCEEDED");
    }

    @Test
    public void testErrorFuture() {
        DeadlineExceededException error = new DeadlineExceededException("Deadline exceeded", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), true);
        TagValue tagValue = Util.extractStatusFromFuture((Future)Futures.immediateFailedFuture((Throwable)error));
        Truth.assertThat((String)tagValue.asString()).isEqualTo((Object)"DEADLINE_EXCEEDED");
    }

    @Test
    public void testCancelledFuture() {
        TagValue tagValue = Util.extractStatusFromFuture((Future)Futures.immediateCancelledFuture());
        Truth.assertThat((String)tagValue.asString()).isEqualTo((Object)"CANCELLED");
    }
}

