/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptCallable;
import com.google.protobuf.ByteString;
import com.google.rpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class MutateRowsAttemptCallableTest {
    private static final Status OK_STATUS_PROTO = Status.newBuilder().setCode(0).build();
    private static final Status TRANSIENT_ERROR_STATUS_PROTO = Status.newBuilder().setCode(14).build();
    private static final Status PERMENANT_ERROR_STATUS_PROTO = Status.newBuilder().setCode(3).build();
    private MockInnerCallable innerCallable;
    private Set<StatusCode.Code> retryCodes;
    private ApiCallContext callContext;
    private MockRetryingFuture parentFuture;

    @Before
    public void setUp() {
        this.innerCallable = new MockInnerCallable();
        this.retryCodes = ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE);
        this.callContext = GrpcCallContext.createDefault();
        this.parentFuture = new MockRetryingFuture();
    }

    @Test
    public void singleEntrySuccessTest() throws Exception {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Truth.assertThat((Object)this.parentFuture.attemptFuture.get()).isNull();
        Truth.assertThat((Object)this.innerCallable.lastRequest).isEqualTo((Object)request);
    }

    @Test
    public void testNoRpcTimeout() {
        this.parentFuture.timedAttemptSettings = this.parentFuture.timedAttemptSettings.toBuilder().setRpcTimeout(Duration.ZERO).build();
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Truth.assertThat((Comparable)this.innerCallable.lastContext.getTimeout()).isNull();
    }

    @Test
    public void mixedTest() {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(1L).setStatus(TRANSIENT_ERROR_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(2L).setStatus(PERMENANT_ERROR_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Throwable actualError = null;
        try {
            this.parentFuture.attemptFuture.get();
        }
        catch (Throwable t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)((MutateRowsException)actualError).isRetryable()).isTrue();
        List failedMutations = ((MutateRowsException)actualError).getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(2);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Comparable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.UNAVAILABLE);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isTrue();
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(1)).getIndex()).isEqualTo((Object)2);
        Truth.assertThat((Comparable)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().isRetryable()).isFalse();
    }

    @Test
    public void nextAttemptTest() {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"0-ok"))).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"1-unavailable"))).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"2-invalid"))).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(1L).setStatus(TRANSIENT_ERROR_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(2L).setStatus(PERMENANT_ERROR_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        this.innerCallable.response = Lists.newArrayList((Object[])new MutateRowsResponse[]{MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).build()});
        attemptCallable.call();
        Truth.assertThat((Integer)this.innerCallable.lastRequest.getEntriesCount()).isEqualTo((Object)1);
        Truth.assertThat((Iterable)this.innerCallable.lastRequest.getEntries(0).getRowKey()).isEqualTo((Object)ByteString.copyFromUtf8((String)"1-unavailable"));
        Throwable actualError = null;
        try {
            this.parentFuture.attemptFuture.get();
        }
        catch (Throwable t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)((MutateRowsException)actualError).isRetryable()).isFalse();
        List failedMutations = ((MutateRowsException)actualError).getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(1);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)2);
        Truth.assertThat((Comparable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isFalse();
    }

    @Test
    public void rpcRetryableError() {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        final UnavailableException rpcError = new UnavailableException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true);
        UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable = new UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>>(){

            public ApiFuture<List<MutateRowsResponse>> futureCall(MutateRowsRequest request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)rpcError);
            }
        };
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)innerCallable, request, this.callContext, this.retryCodes);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Throwable actualError = null;
        try {
            this.parentFuture.attemptFuture.get();
        }
        catch (Throwable t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)((MutateRowsException)actualError).isRetryable()).isTrue();
        List failedMutations = ((MutateRowsException)actualError).getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(2);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)0);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isTrue();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getCause()).isEqualTo((Object)rpcError);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(1)).getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().isRetryable()).isTrue();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().getCause()).isEqualTo((Object)rpcError);
    }

    @Test
    public void rpcPermanentError() {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        final UnavailableException rpcError = new UnavailableException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
        UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable = new UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>>(){

            public ApiFuture<List<MutateRowsResponse>> futureCall(MutateRowsRequest request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)rpcError);
            }
        };
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)innerCallable, request, this.callContext, this.retryCodes);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Throwable actualError = null;
        try {
            this.parentFuture.attemptFuture.get();
        }
        catch (Throwable t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)((MutateRowsException)actualError).isRetryable()).isFalse();
        List failedMutations = ((MutateRowsException)actualError).getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(2);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)0);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isFalse();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getCause()).isEqualTo((Object)rpcError);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(1)).getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().isRetryable()).isFalse();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().getCause()).isEqualTo((Object)rpcError);
    }

    static class MockRetryingFuture
    extends AbstractApiFuture<Void>
    implements RetryingFuture<Void> {
        ApiFuture<Void> attemptFuture;
        TimedAttemptSettings timedAttemptSettings;

        MockRetryingFuture() {
            this(Duration.ofSeconds((long)5L));
        }

        MockRetryingFuture(Duration totalTimeout) {
            this.timedAttemptSettings = TimedAttemptSettings.newBuilder().setRpcTimeout(Duration.ofSeconds((long)1L)).setRetryDelay(Duration.ZERO).setRandomizedRetryDelay(Duration.ZERO).setAttemptCount(0).setFirstAttemptStartTimeNanos(0L).setGlobalSettings(RetrySettings.newBuilder().setTotalTimeout(totalTimeout).build()).build();
        }

        public void setAttemptFuture(ApiFuture<Void> attemptFuture) {
            this.attemptFuture = attemptFuture;
        }

        public TimedAttemptSettings getAttemptSettings() {
            return this.timedAttemptSettings;
        }

        public Callable<Void> getCallable() {
            throw new UnsupportedOperationException("not used");
        }

        public ApiFuture<Void> peekAttemptResult() {
            throw new UnsupportedOperationException("not used");
        }

        public ApiFuture<Void> getAttemptResult() {
            throw new UnsupportedOperationException("not used");
        }
    }

    static class MockInnerCallable
    extends UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> {
        List<MutateRowsResponse> response = Lists.newArrayList();
        MutateRowsRequest lastRequest;
        ApiCallContext lastContext;

        MockInnerCallable() {
        }

        public ApiFuture<List<MutateRowsResponse>> futureCall(MutateRowsRequest request, ApiCallContext context) {
            this.lastRequest = request;
            this.lastContext = context;
            return ApiFutures.immediateFuture(this.response);
        }
    }
}

