/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutateRowsBatchingDescriptorTest {
    private static final String ROW_KEY = "fake-row-key";
    private static final String FAMILY = "fake-family";
    private static final String QUALIFIER = "fake-qualifier";
    private static final String VALUE = "fake-value";
    private static final RequestContext requestContext = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");

    @Test
    public void countBytesTest() {
        RowMutationEntry request = RowMutationEntry.create((String)ROW_KEY).setCell(FAMILY, QUALIFIER, VALUE);
        long bytes = request.toProto().getSerializedSize();
        MutateRowsBatchingDescriptor underTest = new MutateRowsBatchingDescriptor();
        Truth.assertThat((Long)underTest.countBytes(request)).isEqualTo((Object)bytes);
    }

    @Test
    public void requestBuilderTest() {
        MutateRowsBatchingDescriptor underTest = new MutateRowsBatchingDescriptor();
        long timestamp = 10000L;
        BulkMutation bulkMutation = BulkMutation.create((String)"fake-table");
        BatchingRequestBuilder requestBuilder = underTest.newRequestBuilder(bulkMutation);
        requestBuilder.add((Object)RowMutationEntry.create((String)ROW_KEY).setCell(FAMILY, QUALIFIER, timestamp, VALUE));
        requestBuilder.add((Object)RowMutationEntry.create((String)"rowKey-2").setCell("family-2", "q", 20000L, "some-value"));
        BulkMutation actualBulkMutation = (BulkMutation)requestBuilder.build();
        Truth.assertThat((Object)actualBulkMutation.toProto(requestContext)).isEqualTo((Object)BulkMutation.create((String)"fake-table").add(ROW_KEY, Mutation.create().setCell(FAMILY, QUALIFIER, timestamp, VALUE)).add("rowKey-2", Mutation.create().setCell("family-2", "q", 20000L, "some-value")).toProto(requestContext));
    }

    @Test
    public void splitResponseTest() {
        BatchEntry batchEntry1 = BatchEntry.create((Object)RowMutationEntry.create((String)"key1").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        BatchEntry batchEntry2 = BatchEntry.create((Object)RowMutationEntry.create((String)"key2").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        ImmutableList batchResponse = ImmutableList.of((Object)batchEntry1, (Object)batchEntry2);
        Truth.assertThat((Boolean)((BatchEntry)batchResponse.get(0)).getResultFuture().isDone()).isFalse();
        Truth.assertThat((Boolean)((BatchEntry)batchResponse.get(1)).getResultFuture().isDone()).isFalse();
        MutateRowsBatchingDescriptor underTest = new MutateRowsBatchingDescriptor();
        underTest.splitResponse(null, (List)batchResponse);
        Truth.assertThat((Boolean)((BatchEntry)batchResponse.get(0)).getResultFuture().isDone()).isTrue();
        Truth.assertThat((Boolean)((BatchEntry)batchResponse.get(1)).getResultFuture().isDone()).isTrue();
    }

    @Test
    public void splitExceptionTest() {
        BatchEntry batchEntry1 = BatchEntry.create((Object)RowMutationEntry.create((String)"key1").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        BatchEntry batchEntry2 = BatchEntry.create((Object)RowMutationEntry.create((String)"key2").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        MutateRowsBatchingDescriptor underTest = new MutateRowsBatchingDescriptor();
        RuntimeException expectedEx = new RuntimeException("Caused while batching");
        ImmutableList batchResponses = ImmutableList.of((Object)batchEntry1, (Object)batchEntry2);
        underTest.splitException((Throwable)expectedEx, (List)batchResponses);
        for (BatchEntry response : batchResponses) {
            try {
                response.getResultFuture().get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Truth.assertThat((Throwable)ex).hasCauseThat().isSameInstanceAs((Object)expectedEx);
            }
        }
    }

    @Test
    public void splitExceptionWithFailedMutationsTest() {
        MutateRowsBatchingDescriptor underTest = new MutateRowsBatchingDescriptor();
        Exception actualThrowable = null;
        BatchEntry batchEntry1 = BatchEntry.create((Object)RowMutationEntry.create((String)"key1").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        BatchEntry batchEntry2 = BatchEntry.create((Object)RowMutationEntry.create((String)"key2").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        BatchEntry batchEntry3 = BatchEntry.create((Object)RowMutationEntry.create((String)"key3").deleteRow(), (SettableApiFuture)SettableApiFuture.create());
        MutateRowsException serverError = new MutateRowsException(null, (List)ImmutableList.of((Object)MutateRowsException.FailedMutation.create((int)0, (ApiException)new UnavailableException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true)), (Object)MutateRowsException.FailedMutation.create((int)2, (ApiException)new DeadlineExceededException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), true))), true);
        underTest.splitException((Throwable)serverError, (List)ImmutableList.of((Object)batchEntry1, (Object)batchEntry2, (Object)batchEntry3));
        try {
            batchEntry1.getResultFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            actualThrowable = e;
        }
        Truth.assertThat((Throwable)actualThrowable).hasCauseThat().isEqualTo((Object)((MutateRowsException.FailedMutation)serverError.getFailedMutations().get(0)).getError());
        actualThrowable = null;
        try {
            batchEntry2.getResultFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            actualThrowable = e;
        }
        Truth.assertThat((Throwable)actualThrowable).isNull();
        actualThrowable = null;
        try {
            batchEntry3.getResultFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            actualThrowable = e;
        }
        Truth.assertThat((Throwable)actualThrowable).hasCauseThat().isEqualTo((Object)((MutateRowsException.FailedMutation)serverError.getFailedMutations().get(1)).getError());
    }
}

