/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannel;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.beam.io.pubsub.io.grpc.testing.GrpcServerRule;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Queues;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutateRowsRetryTest {
    @Rule
    public GrpcServerRule serverRule = new GrpcServerRule();
    private FakeBigtableService service;
    private BigtableDataClient client;
    private AtomicInteger attemptCounter = new AtomicInteger();

    @Before
    public void setUp() throws IOException {
        this.service = new FakeBigtableService();
        this.serverRule.getServiceRegistry().addService((BindableService)this.service);
        BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilder().setProjectId("fake-project").setInstanceId("fake-instance").setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
        ((EnhancedBigtableStubSettings.Builder)settings.stubSettings().setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.serverRule.getChannel())))).build();
        this.client = BigtableDataClient.create((BigtableDataSettings)settings.build());
    }

    @Test
    public void testRetryRstStream() {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("INTERNAL: HTTP/2 error code: INTERNAL_ERROR\nReceived Rst Stream")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        this.service.expectations.add((Exception)exception);
        try {
            this.client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"row-key-1").setCell("cf", "q", "v")));
        }
        catch (ApiException e) {
            Assert.fail((String)"Rst stream errors should be retried");
        }
        Assert.assertEquals((long)this.attemptCounter.get(), (long)2L);
    }

    private class FakeBigtableService
    extends BigtableGrpc.BigtableImplBase {
        Queue<Exception> expectations = Queues.newArrayDeque();

        private FakeBigtableService() {
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            MutateRowsRetryTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)MutateRowsResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }
    }
}

