/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.protobuf.ByteString;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterMarkerRowsCallableTest {
    private final DefaultRowAdapter rowAdapter = new DefaultRowAdapter();

    @Test
    public void testEmpty() {
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        FilterMarkerRowsCallable filterCallable = new FilterMarkerRowsCallable(innerCallable, (RowAdapter)this.rowAdapter);
        ServerStream results = filterCallable.call((Object)ReadRowsRequest.getDefaultInstance());
        Truth.assertThat((Iterable)results).isEmpty();
    }

    @Test
    public void testOnlyMarker() {
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new Row[]{this.buildScanMarker()}));
        FilterMarkerRowsCallable filterCallable = new FilterMarkerRowsCallable(innerCallable, (RowAdapter)this.rowAdapter);
        ServerStream results = filterCallable.call((Object)ReadRowsRequest.getDefaultInstance());
        Truth.assertThat((Iterable)results).isEmpty();
    }

    @Test
    public void testRealRow() {
        Row row = this.buildRealRow();
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new Row[]{row}));
        FilterMarkerRowsCallable filterCallable = new FilterMarkerRowsCallable(innerCallable, (RowAdapter)this.rowAdapter);
        ServerStream results = filterCallable.call((Object)ReadRowsRequest.getDefaultInstance());
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{row});
    }

    @Test
    public void testMixed() {
        Row row = this.buildRealRow();
        Row markerRow = this.buildScanMarker();
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new Row[]{row, markerRow}));
        FilterMarkerRowsCallable filterCallable = new FilterMarkerRowsCallable(innerCallable, (RowAdapter)this.rowAdapter);
        ServerStream results = filterCallable.call((Object)ReadRowsRequest.getDefaultInstance());
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{row});
    }

    private Row buildRealRow() {
        RowAdapter.RowBuilder rowBuilder = this.rowAdapter.createRowBuilder();
        rowBuilder.startRow(ByteString.copyFromUtf8((String)"fake-key"));
        rowBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifer"), 1000L, (List)Lists.newArrayList(), 0L);
        rowBuilder.cellValue(ByteString.copyFromUtf8((String)"fake-value"));
        rowBuilder.finishCell();
        return (Row)rowBuilder.finishRow();
    }

    private Row buildScanMarker() {
        return (Row)this.rowAdapter.createRowBuilder().createScanMarkerRow(ByteString.copyFromUtf8((String)"fake-key2"));
    }
}

