/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsFirstCallable;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;

@RunWith(value=JUnit4.class)
public class ReadRowsFirstCallableTest {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.WARN);
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    private ServerStreamingCallable<Query, Row> innerCallable;
    private ArgumentCaptor<Query> innerQuery;

    @Before
    public void setUp() {
        this.innerCallable = (ServerStreamingCallable)Mockito.mock(ServerStreamingCallable.class);
        this.innerQuery = ArgumentCaptor.forClass(Query.class);
    }

    @Test
    public void testLimitAdded() {
        ReadRowsFirstCallable callable = new ReadRowsFirstCallable(this.innerCallable);
        callable.futureCall(Query.create((String)"fake-table"), (ApiCallContext)GrpcCallContext.createDefault());
        ((ServerStreamingCallable)Mockito.verify(this.innerCallable)).call(this.innerQuery.capture(), (ResponseObserver)ArgumentMatchers.any(ResponseObserver.class), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class));
        Truth.assertThat((Object)((Query)this.innerQuery.getValue()).toProto(REQUEST_CONTEXT)).isEqualTo((Object)Query.create((String)"fake-table").limit(1L).toProto(REQUEST_CONTEXT));
    }

    @Test
    public void testLimitChanged() {
        ReadRowsFirstCallable callable = new ReadRowsFirstCallable(this.innerCallable);
        callable.futureCall(Query.create((String)"fake-table").limit(10L), (ApiCallContext)GrpcCallContext.createDefault());
        ((ServerStreamingCallable)Mockito.verify(this.innerCallable)).call(this.innerQuery.capture(), (ResponseObserver)ArgumentMatchers.any(ResponseObserver.class), (ApiCallContext)ArgumentMatchers.any(ApiCallContext.class));
        Truth.assertThat((Object)((Query)this.innerQuery.getValue()).toProto(REQUEST_CONTEXT)).isEqualTo((Object)Query.create((String)"fake-table").limit(1L).toProto(REQUEST_CONTEXT));
    }
}

