/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.cloud.conformance.bigtable.v2.TestDefinition;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import cz.o2.proxima.internal.shaded.com.google.common.base.CaseFormat;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReadRowsMergingAcceptanceTest {
    private static final String TEST_DATA_JSON_RESOURCE = "com/google/cloud/conformance/bigtable/v2/readrows.json";
    private final TestDefinition.ReadRowsTest testCase;

    public ReadRowsMergingAcceptanceTest(TestDefinition.ReadRowsTest testData, String junitName) {
        this.testCase = testData;
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream dataJson = cl.getResourceAsStream(TEST_DATA_JSON_RESOURCE);
        Truth.assertWithMessage((String)"Unable to load test definition: %s", (Object[])new Object[]{TEST_DATA_JSON_RESOURCE}).that((Object)dataJson).isNotNull();
        InputStreamReader reader = new InputStreamReader(dataJson);
        TestDefinition.TestFile.Builder testBuilder = TestDefinition.TestFile.newBuilder();
        JsonFormat.parser().merge((Reader)reader, (Message.Builder)testBuilder);
        TestDefinition.TestFile testDefinition = testBuilder.build();
        List tests = testDefinition.getReadRowsTestsList();
        ArrayList<Object[]> data = new ArrayList<Object[]>(tests.size());
        for (TestDefinition.ReadRowsTest test : tests) {
            String junitName = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, test.getDescription().replace(" ", "-"));
            data.add(new Object[]{test, junitName});
        }
        return data;
    }

    @Test
    public void test() throws Exception {
        ArrayList responses = Lists.newArrayList();
        for (ReadRowsResponse.CellChunk chunk : this.testCase.getChunksList()) {
            ReadRowsResponse.Builder responseBuilder = ReadRowsResponse.newBuilder();
            responseBuilder.addChunks(chunk);
            responses.add(responseBuilder.build());
        }
        FakeStreamingApi.ServerStreamingStashCallable source = new FakeStreamingApi.ServerStreamingStashCallable(responses);
        RowMergingCallable mergingCallable = new RowMergingCallable(source, (RowAdapter)new DefaultRowAdapter());
        ServerStream stream = mergingCallable.call((Object)ReadRowsRequest.getDefaultInstance());
        ArrayList actualResults = Lists.newArrayList();
        Exception error = null;
        try {
            for (Row row : stream) {
                for (RowCell cell : row.getCells()) {
                    actualResults.add(TestDefinition.ReadRowsTest.Result.newBuilder().setRowKeyBytes(row.getKey()).setFamilyName(cell.getFamily()).setQualifierBytes(cell.getQualifier()).setTimestampMicros(cell.getTimestamp()).setValueBytes(cell.getValue()).setLabel(cell.getLabels().isEmpty() ? "" : (String)cell.getLabels().get(0)).build());
                }
            }
        }
        catch (Exception e) {
            error = e;
        }
        if (ReadRowsMergingAcceptanceTest.expectsError(this.testCase)) {
            Truth.assertThat((Throwable)error).isNotNull();
        } else if (error != null) {
            throw error;
        }
        Truth.assertThat(ReadRowsMergingAcceptanceTest.getNonExceptionResults(this.testCase)).isEqualTo((Object)actualResults);
    }

    private static boolean expectsError(TestDefinition.ReadRowsTest rrt) {
        List results = rrt.getResultsList();
        return results != null && !results.isEmpty() && ((TestDefinition.ReadRowsTest.Result)results.get(results.size() - 1)).getError();
    }

    private static List<TestDefinition.ReadRowsTest.Result> getNonExceptionResults(TestDefinition.ReadRowsTest rrt) {
        List results = rrt.getResultsList();
        ArrayList<TestDefinition.ReadRowsTest.Result> response = new ArrayList<TestDefinition.ReadRowsTest.Result>();
        if (results != null) {
            for (TestDefinition.ReadRowsTest.Result result : results) {
                if (result.getError()) continue;
                response.add(result);
            }
        }
        return response;
    }
}

