/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.RowRange;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import cz.o2.proxima.beam.io.pubsub.io.grpc.BindableService;
import cz.o2.proxima.beam.io.pubsub.io.grpc.ManagedChannel;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import cz.o2.proxima.beam.io.pubsub.io.grpc.StatusRuntimeException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.stub.StreamObserver;
import cz.o2.proxima.beam.io.pubsub.io.grpc.testing.GrpcServerRule;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Queues;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Range;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadRowsRetryTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    @Rule
    public GrpcServerRule serverRule = new GrpcServerRule();
    private TestBigtableService service;
    private BigtableDataClient client;

    @Before
    public void setUp() throws IOException {
        this.service = new TestBigtableService();
        this.serverRule.getServiceRegistry().addService((BindableService)this.service);
        BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilder().setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
        ((EnhancedBigtableStubSettings.Builder)settings.stubSettings().setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.serverRule.getChannel())))).build();
        this.client = BigtableDataClient.create((BigtableDataSettings)settings.build());
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void happyPathTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest("k1").expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).respondWith("k1", "r1", "r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).rowKey("k1").range("r1", "r3"));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"k1", "r1", "r2"}).inOrder();
    }

    @Test
    public void immediateRetryTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest("k1").expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("k1").expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).respondWith("k1", "r1", "r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).rowKey("k1").range("r1", "r3"));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"k1", "r1", "r2"}).inOrder();
    }

    @Test
    public void multipleRetryTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r9"))).respondWith("r1", "r2", "r3", "r4").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.open((Comparable)((Object)"r4"), (Comparable)((Object)"r9"))).respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.open((Comparable)((Object)"r4"), (Comparable)((Object)"r9"))).respondWith("r5", "r6", "r7").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.open((Comparable)((Object)"r7"), (Comparable)((Object)"r9"))).respondWith("r8"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range("r1", "r9"));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2", "r3", "r4", "r5", "r6", "r7", "r8"}).inOrder();
    }

    @Test
    public void rowLimitTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).expectRowLimit(2).respondWith("r1").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.open((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).expectRowLimit(1).respondWith("r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range("r1", "r3").limit(2L));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2"}).inOrder();
    }

    @Test
    public void errorAfterRowLimitMetTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).expectRowLimit(2).respondWith("r1", "r2").respondWithStatus(Status.Code.UNAVAILABLE));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range("r1", "r3").limit(2L));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2"});
    }

    @Test
    public void errorAfterRequestCompleteTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).expectRequest("r4").respondWith("r2", "r4").respondWithStatus(Status.Code.UNAVAILABLE));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range("r1", "r3").rowKey("r4"));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r2", "r4"});
    }

    @Test
    public void pointTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest("r1", "r2").respondWith("r1").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest("r2").respondWith("r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).rowKey("r1").rowKey("r2"));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2"}).inOrder();
    }

    @Test
    public void fullTableScanTest() {
        this.service.expectations.add(RpcExpectation.create().respondWith("r1").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.greaterThan((Comparable)((Object)"r1"))).respondWith("r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2"}).inOrder();
    }

    @Test
    public void retryUnboundedStartTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.lessThan((Comparable)((Object)"r9"))).respondWith("r1").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.open((Comparable)((Object)"r1"), (Comparable)((Object)"r9"))).respondWith("r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range((Range.ByteStringRange)Range.ByteStringRange.unbounded().endOpen("r9")));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2"}).inOrder();
    }

    @Test
    public void retryUnboundedEndTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.atLeast((Comparable)((Object)"r1"))).respondWith("r1").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.greaterThan((Comparable)((Object)"r1"))).respondWith("r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range((Range.ByteStringRange)Range.ByteStringRange.unbounded().startClosed("r1")));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r1", "r2"}).inOrder();
    }

    @Test
    public void retryWithLastScannedKeyTest() {
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r9"))).respondWithLastScannedKey("r5").respondWithStatus(Status.Code.UNAVAILABLE));
        this.service.expectations.add(RpcExpectation.create().expectRequest((Range<String>)Range.open((Comparable)((Object)"r5"), (Comparable)((Object)"r9"))).respondWith("r7"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).range(Range.ByteStringRange.create((String)"r1", (String)"r9")));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"r7"}).inOrder();
    }

    @Test
    public void retryRstStreamExceptionTest() {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("INTERNAL: HTTP/2 error code: INTERNAL_ERROR\nReceived Rst Stream")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        this.service.expectations.add(RpcExpectation.create().expectRequest("k1").expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).respondWithException(Status.Code.INTERNAL, (ApiException)exception));
        this.service.expectations.add(RpcExpectation.create().expectRequest("k1").expectRequest((Range<String>)Range.closedOpen((Comparable)((Object)"r1"), (Comparable)((Object)"r3"))).respondWith("k1", "r1", "r2"));
        List<String> actualResults = this.getResults(Query.create((String)TABLE_ID).rowKey("k1").range("r1", "r3"));
        Truth.assertThat(actualResults).containsExactly(new Object[]{"k1", "r1", "r2"}).inOrder();
    }

    private List<String> getResults(Query query) {
        ServerStream actualRows = this.client.readRows(query);
        ArrayList actualValues = Lists.newArrayList();
        for (Row row : actualRows) {
            actualValues.add(row.getKey().toStringUtf8());
        }
        return actualValues;
    }

    private static class RpcExpectation {
        ReadRowsRequest.Builder requestBuilder = ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)"fake-project", (String)"fake-instance", (String)"fake-table"));
        Status.Code statusCode = Status.Code.OK;
        ApiException exception;
        List<ReadRowsResponse> responses = Lists.newArrayList();

        private RpcExpectation() {
        }

        static RpcExpectation create() {
            return new RpcExpectation();
        }

        RpcExpectation expectRequest(String ... keys) {
            for (String key : keys) {
                this.requestBuilder.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)key));
            }
            return this;
        }

        RpcExpectation expectRequest(Range<String> range) {
            block11: {
                RowRange.Builder rowRange;
                block10: {
                    block9: {
                        block8: {
                            rowRange = this.requestBuilder.getRowsBuilder().addRowRangesBuilder();
                            if (!range.hasLowerBound()) break block8;
                            switch (range.lowerBoundType()) {
                                case CLOSED: {
                                    rowRange.setStartKeyClosed(ByteString.copyFromUtf8((String)((String)((Object)range.lowerEndpoint()))));
                                    break block9;
                                }
                                case OPEN: {
                                    rowRange.setStartKeyOpen(ByteString.copyFromUtf8((String)((String)((Object)range.lowerEndpoint()))));
                                    break block9;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unexpected lowerBoundType: " + range.lowerBoundType());
                                }
                            }
                        }
                        rowRange.clearStartKey();
                    }
                    if (!range.hasUpperBound()) break block10;
                    switch (range.upperBoundType()) {
                        case CLOSED: {
                            rowRange.setEndKeyClosed(ByteString.copyFromUtf8((String)((String)((Object)range.upperEndpoint()))));
                            break block11;
                        }
                        case OPEN: {
                            rowRange.setEndKeyOpen(ByteString.copyFromUtf8((String)((String)((Object)range.upperEndpoint()))));
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected upperBoundType: " + range.upperBoundType());
                        }
                    }
                }
                rowRange.clearEndKey();
            }
            return this;
        }

        RpcExpectation expectRowLimit(int limit) {
            this.requestBuilder.setRowsLimit((long)limit);
            return this;
        }

        RpcExpectation respondWithStatus(Status.Code code) {
            this.statusCode = code;
            return this;
        }

        RpcExpectation respondWithException(Status.Code code, ApiException exception) {
            this.statusCode = code;
            this.exception = exception;
            return this;
        }

        RpcExpectation respondWith(String ... responses) {
            for (String response : responses) {
                this.responses.add(ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)response)).setFamilyName(StringValue.newBuilder().setValue("family").build()).setQualifier(BytesValue.newBuilder().setValue(ByteString.EMPTY).build()).setTimestampMicros(10000L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(true)).build());
            }
            return this;
        }

        RpcExpectation respondWithLastScannedKey(String key) {
            this.responses.add(ReadRowsResponse.newBuilder().setLastScannedRowKey(ByteString.copyFromUtf8((String)key)).build());
            return this;
        }

        ReadRowsRequest getExpectedRequest() {
            return this.requestBuilder.build();
        }
    }

    private static class TestBigtableService
    extends BigtableGrpc.BigtableImplBase {
        Queue<RpcExpectation> expectations = Queues.newArrayDeque();
        int i = -1;

        private TestBigtableService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            RpcExpectation expectedRpc = this.expectations.poll();
            ++this.i;
            Truth.assertWithMessage((String)("Unexpected request#" + this.i + ":" + request.toString())).that((Object)expectedRpc).isNotNull();
            Truth.assertWithMessage((String)("Unexpected request#" + this.i)).that((Object)request).isEqualTo((Object)expectedRpc.getExpectedRequest());
            for (ReadRowsResponse response : expectedRpc.responses) {
                responseObserver.onNext((Object)response);
            }
            if (expectedRpc.statusCode.toStatus().isOk()) {
                responseObserver.onCompleted();
            } else if (expectedRpc.exception != null) {
                responseObserver.onError((Throwable)expectedRpc.exception);
            } else {
                responseObserver.onError((Throwable)expectedRpc.statusCode.toStatus().asRuntimeException());
            }
        }
    }
}

