/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.stub.readrows.StateMachine;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StateMachineTest {
    StateMachine<Row> stateMachine;

    @Before
    public void setUp() throws Exception {
        this.stateMachine = new StateMachine(new DefaultRowAdapter().createRowBuilder());
    }

    @Test
    public void testErrorHandlingStats() {
        StateMachine.InvalidInputException actualError = null;
        ReadRowsResponse.CellChunk chunk = ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"my-key1")).setFamilyName(StringValue.newBuilder().setValue("my-family")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"q"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"my-value")).setCommitRow(true).build();
        try {
            this.stateMachine.handleChunk(chunk);
            this.stateMachine.consumeRow();
            this.stateMachine.handleChunk(chunk.toBuilder().setRowKey(ByteString.copyFromUtf8((String)"my-key2")).build());
            this.stateMachine.consumeRow();
            this.stateMachine.handleChunk(chunk.toBuilder().setRowKey(ByteString.copyFromUtf8((String)"my-key3")).setValueSize(123).build());
        }
        catch (StateMachine.InvalidInputException e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).hasMessageThat().containsMatch("last5Keys: .*my-key1.*my-key2");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numScannedNotifications: 0");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numChunksProcessed: 3");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numCellsInRow: 0");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numCellsInLastRow: 1");
    }
}

