/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.MonitoredResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.stats.BigtableCreateTimeSeriesExporter;
import com.google.cloud.bigtable.stats.BuiltinMeasureConstants;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import io.opencensus.common.Timestamp;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Value;
import java.util.Arrays;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class BigtableCreateTimeSeriesExporterTest {
    private static final String projectId = "fake-project";
    private static final String instanceId = "fake-instance";
    private static final String appProfileId = "default";
    private static final String tableId = "fake-table";
    private static final String zone = "us-east-1";
    private static final String cluster = "cluster-1";
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private MetricServiceStub mockMetricServiceStub;
    private MetricServiceClient fakeMetricServiceClient;
    private BigtableCreateTimeSeriesExporter exporter;

    @Before
    public void setUp() {
        this.fakeMetricServiceClient = new FakeMetricServiceClient(this.mockMetricServiceStub);
        this.exporter = new BigtableCreateTimeSeriesExporter(this.fakeMetricServiceClient, MonitoredResource.newBuilder().setType("bigtable-table").build());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testTimeSeries() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        Mockito.when((Object)mockCallable.call(argumentCaptor.capture())).thenReturn((Object)Empty.getDefaultInstance());
        double fakeValue = 10.0;
        Metric fakeMetric = Metric.create((MetricDescriptor)MetricDescriptor.create((String)"bigtable/test", (String)"descritpion", (String)"ms", (MetricDescriptor.Type)MetricDescriptor.Type.CUMULATIVE_DOUBLE, Arrays.asList(LabelKey.create((String)BuiltinMeasureConstants.PROJECT_ID.getName(), (String)""), LabelKey.create((String)BuiltinMeasureConstants.INSTANCE_ID.getName(), (String)""), LabelKey.create((String)BuiltinMeasureConstants.TABLE.getName(), (String)""), LabelKey.create((String)BuiltinMeasureConstants.CLUSTER.getName(), (String)""), LabelKey.create((String)BuiltinMeasureConstants.ZONE.getName(), (String)""), LabelKey.create((String)BuiltinMeasureConstants.APP_PROFILE.getName(), (String)""))), Arrays.asList(io.opencensus.metrics.export.TimeSeries.create(Arrays.asList(LabelValue.create((String)projectId), LabelValue.create((String)instanceId), LabelValue.create((String)tableId), LabelValue.create((String)cluster), LabelValue.create((String)zone), LabelValue.create((String)appProfileId)), Arrays.asList(Point.create((Value)Value.doubleValue((double)fakeValue), (Timestamp)Timestamp.fromMillis((long)System.currentTimeMillis()))), (Timestamp)Timestamp.fromMillis((long)System.currentTimeMillis()))));
        this.exporter.export(Arrays.asList(fakeMetric));
        CreateTimeSeriesRequest request = (CreateTimeSeriesRequest)argumentCaptor.getValue();
        Truth.assertThat((Iterable)request.getTimeSeriesList()).hasSize(1);
        TimeSeries timeSeries = (TimeSeries)request.getTimeSeriesList().get(0);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltinMeasureConstants.PROJECT_ID.getName(), (Object)projectId, new Object[]{BuiltinMeasureConstants.INSTANCE_ID.getName(), instanceId, BuiltinMeasureConstants.TABLE.getName(), tableId, BuiltinMeasureConstants.CLUSTER.getName(), cluster, BuiltinMeasureConstants.ZONE.getName(), zone});
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(2);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsAtLeast((Object)BuiltinMeasureConstants.APP_PROFILE.getName(), (Object)appProfileId, new Object[0]);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsKey((Object)BuiltinMeasureConstants.CLIENT_UID.getName());
        Truth.assertThat((Double)timeSeries.getPoints(0).getValue().getDoubleValue()).isEqualTo((Object)fakeValue);
    }

    private class FakeMetricServiceClient
    extends MetricServiceClient {
        protected FakeMetricServiceClient(MetricServiceStub stub) {
            super(stub);
        }
    }
}

