/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.bigtable.stats.BuiltinMeasureConstants;
import com.google.cloud.bigtable.stats.BuiltinViewConstants;
import com.google.cloud.bigtable.stats.BuiltinViews;
import com.google.cloud.bigtable.stats.StatsRecorderWrapper;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableMap;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import io.opencensus.impl.stats.StatsComponentImpl;
import io.opencensus.stats.AggregationData;
import io.opencensus.stats.StatsComponent;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewData;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StatsRecorderWrapperTest {
    private final String PROJECT_ID = "fake-project";
    private final String INSTANCE_ID = "fake-instance";
    private final String APP_PROFILE_ID = "fake-app-profile";
    private final String TABLE_ID = "fake-table-id";
    private final String ZONE = "fake-zone";
    private final String CLUSTER = "fake-cluster";
    private final StatsComponent statsComponent = new StatsComponentImpl();

    @Before
    public void setup() {
        BuiltinViews views = new BuiltinViews();
        views.registerPrivateViews(this.statsComponent.getViewManager());
    }

    @Test
    public void testStreamingOperation() throws InterruptedException {
        StatsRecorderWrapper recorderWrapper = new StatsRecorderWrapper(ApiTracerFactory.OperationType.ServerStreaming, SpanName.of((String)"Bigtable", (String)"ReadRows"), (Map)ImmutableMap.of((Object)BuiltinMeasureConstants.PROJECT_ID.getName(), (Object)"fake-project", (Object)BuiltinMeasureConstants.INSTANCE_ID.getName(), (Object)"fake-instance", (Object)BuiltinMeasureConstants.APP_PROFILE.getName(), (Object)"fake-app-profile"), this.statsComponent.getStatsRecorder());
        long operationLatency = 1234L;
        int attemptCount = 2;
        long attemptLatency = 56L;
        long serverLatency = 78L;
        long applicationLatency = 901L;
        long connectivityErrorCount = 15L;
        long throttlingLatency = 50L;
        long firstResponseLatency = 90L;
        recorderWrapper.putOperationLatencies(operationLatency);
        recorderWrapper.putRetryCount(attemptCount);
        recorderWrapper.putAttemptLatencies(attemptLatency);
        recorderWrapper.putApplicationLatencies(applicationLatency);
        recorderWrapper.putGfeLatencies(serverLatency);
        recorderWrapper.putGfeMissingHeaders(connectivityErrorCount);
        recorderWrapper.putFirstResponseLatencies(firstResponseLatency);
        recorderWrapper.putBatchRequestThrottled(throttlingLatency);
        recorderWrapper.recordOperation("OK", "fake-table-id", "fake-zone", "fake-cluster");
        recorderWrapper.recordAttempt("OK", "fake-table-id", "fake-zone", "fake-cluster");
        Thread.sleep(100L);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.OPERATION_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"true"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)operationLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.ATTEMPT_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"true"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)attemptLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.RETRY_COUNT_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)attemptCount);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.SERVER_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"true", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)serverLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.APPLICATION_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"true"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)applicationLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.CONNECTIVITY_ERROR_COUNT_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)connectivityErrorCount);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.THROTTLING_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)throttlingLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.FIRST_RESPONSE_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.ReadRows", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.STATUS, (Object)"OK", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)firstResponseLatency);
    }

    @Test
    public void testUnaryOperations() throws InterruptedException {
        StatsRecorderWrapper recorderWrapper = new StatsRecorderWrapper(ApiTracerFactory.OperationType.Unary, SpanName.of((String)"Bigtable", (String)"MutateRow"), (Map)ImmutableMap.of((Object)BuiltinMeasureConstants.PROJECT_ID.getName(), (Object)"fake-project", (Object)BuiltinMeasureConstants.INSTANCE_ID.getName(), (Object)"fake-instance", (Object)BuiltinMeasureConstants.APP_PROFILE.getName(), (Object)"fake-app-profile"), this.statsComponent.getStatsRecorder());
        long operationLatency = 1234L;
        int attemptCount = 2;
        long attemptLatency = 56L;
        long serverLatency = 78L;
        long applicationLatency = 901L;
        long connectivityErrorCount = 15L;
        long throttlingLatency = 50L;
        long firstResponseLatency = 90L;
        recorderWrapper.putOperationLatencies(operationLatency);
        recorderWrapper.putRetryCount(attemptCount);
        recorderWrapper.putAttemptLatencies(attemptLatency);
        recorderWrapper.putApplicationLatencies(applicationLatency);
        recorderWrapper.putGfeLatencies(serverLatency);
        recorderWrapper.putGfeMissingHeaders(connectivityErrorCount);
        recorderWrapper.putFirstResponseLatencies(firstResponseLatency);
        recorderWrapper.putBatchRequestThrottled(throttlingLatency);
        recorderWrapper.recordOperation("UNAVAILABLE", "fake-table-id", "fake-zone", "fake-cluster");
        recorderWrapper.recordAttempt("UNAVAILABLE", "fake-table-id", "fake-zone", "fake-cluster");
        Thread.sleep(100L);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.OPERATION_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"false"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)operationLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.ATTEMPT_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"false"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)attemptLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.RETRY_COUNT_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)attemptCount);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.SERVER_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"false", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)serverLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.APPLICATION_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.STREAMING, (Object)"false"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)applicationLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.CONNECTIVITY_ERROR_COUNT_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)connectivityErrorCount);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.THROTTLING_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)throttlingLatency);
        Truth.assertThat((Long)this.getAggregationValueAsLong(BuiltinViewConstants.FIRST_RESPONSE_LATENCIES_VIEW, (ImmutableMap<TagKey, String>)ImmutableMap.of((Object)BuiltinMeasureConstants.METHOD, (Object)"Bigtable.MutateRow", (Object)BuiltinMeasureConstants.TABLE, (Object)"fake-table-id", (Object)BuiltinMeasureConstants.ZONE, (Object)"fake-zone", (Object)BuiltinMeasureConstants.CLUSTER, (Object)"fake-cluster", (Object)BuiltinMeasureConstants.STATUS, (Object)"UNAVAILABLE", (Object)BuiltinMeasureConstants.CLIENT_NAME, (Object)"bigtable-java"), "fake-project", "fake-instance", "fake-app-profile", this.statsComponent.getViewManager())).isEqualTo((Object)firstResponseLatency);
    }

    long getAggregationValueAsLong(View view, ImmutableMap<TagKey, String> tags, String projectId, String instanceId, String appProfileId, ViewManager viewManager) {
        ViewData viewData = viewManager.getView(view.getName());
        Map aggregationMap = Objects.requireNonNull(viewData).getAggregationMap();
        ArrayList<TagValue> tagValues = new ArrayList<TagValue>();
        for (TagKey column : view.getColumns()) {
            if (BuiltinMeasureConstants.PROJECT_ID == column) {
                tagValues.add(TagValue.create((String)projectId));
                continue;
            }
            if (BuiltinMeasureConstants.INSTANCE_ID == column) {
                tagValues.add(TagValue.create((String)instanceId));
                continue;
            }
            if (BuiltinMeasureConstants.APP_PROFILE == column) {
                tagValues.add(TagValue.create((String)appProfileId));
                continue;
            }
            tagValues.add(TagValue.create((String)((String)tags.get((Object)column))));
        }
        AggregationData aggregationData = (AggregationData)aggregationMap.get(tagValues);
        return (Long)aggregationData.match(arg -> (long)arg.getSum(), AggregationData.SumDataLong::getSum, arg -> arg.getCount(), arg -> (long)arg.getMean(), arg -> (long)arg.getLastValue(), AggregationData.LastValueDataLong::getLastValue, arg -> {
            throw new UnsupportedOperationException();
        });
    }
}

