/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.test_helpers.env;

import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import cz.o2.proxima.internal.shaded.com.google.common.base.MoreObjects;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractTestEnv {
    private String primaryClusterId = null;

    abstract void start() throws Exception;

    abstract void stop() throws Exception;

    public abstract BigtableDataClient getDataClient();

    public abstract BigtableDataClient getDataClientForInstance(String var1) throws IOException;

    public abstract BigtableTableAdminClient getTableAdminClient();

    public abstract BigtableTableAdminClient getTableAdminClientForInstance(String var1) throws IOException;

    public abstract BigtableInstanceAdminClient getInstanceAdminClient();

    public abstract BigtableDataSettings getDataClientSettings();

    public abstract BigtableInstanceAdminSettings getInstanceAdminClientSettings();

    public abstract BigtableTableAdminSettings getTableAdminSettings();

    public abstract String getProjectId();

    public abstract String getInstanceId();

    public synchronized String getPrimaryClusterId() {
        if (this.primaryClusterId != null) {
            return this.primaryClusterId;
        }
        List clusters = this.getInstanceAdminClient().listClusters(this.getInstanceId());
        HashMap<String, Cluster> byId = new HashMap<String, Cluster>();
        for (Cluster cluster : clusters) {
            byId.put(cluster.getId(), cluster);
        }
        Cluster cluster = null;
        cluster = (Cluster)byId.get(this.getInstanceId());
        if (cluster == null) {
            cluster = (Cluster)byId.get(this.getInstanceId() + "-cluster");
        }
        if (cluster == null) {
            cluster = (Cluster)byId.get(this.getInstanceId() + "-c0");
        }
        this.primaryClusterId = ((Cluster)Preconditions.checkNotNull((Object)cluster, (String)"Failed to guess the primary cluster for projects/%s/instances/%s", (Object)this.getProjectId(), (Object)this.getInstanceId())).getId();
        return this.primaryClusterId;
    }

    public abstract String getTableId();

    public abstract String getKmsKeyName();

    public String getFamilyId() {
        return "cf";
    }

    public boolean isInstanceAdminSupported() {
        return true;
    }

    public ConnectionMode getConnectionMode() {
        String modeStr = (String)MoreObjects.firstNonNull((Object)System.getProperty("bigtable.connection-mode"), (Object)ConnectionMode.DEFAULT.name());
        return ConnectionMode.valueOf(modeStr);
    }

    public boolean shouldWaitForCmekKeyStatusUpdate() {
        return Boolean.getBoolean("bigtable.wait-for-cmek-key-status");
    }

    public String getPrimaryZone() {
        return "us-central1-b";
    }

    public String getSecondaryZone() {
        return "us-east1-b";
    }

    public List<String> getMultipleZonesInSameRegion() {
        return ImmutableList.of((Object)"us-east1-b", (Object)"us-east1-c");
    }

    public static enum ConnectionMode {
        DEFAULT,
        REQUIRE_CFE,
        REQUIRE_DIRECT_PATH,
        REQUIRE_DIRECT_PATH_IPV4;

    }
}

