/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.test_helpers.env;

import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.emulator.v2.Emulator;
import com.google.cloud.bigtable.test_helpers.env.AbstractTestEnv;
import cz.o2.proxima.internal.shaded.com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class EmulatorEnv
extends AbstractTestEnv {
    private static final String EMULATOR_OVERRIDE_PROPERTY_NAME = "bigtable.emulator-path";
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "default-table";
    private Emulator emulator;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableDataClient dataClient;
    private BigtableDataSettings dataSettings;
    private BigtableTableAdminSettings tableAdminSettings;

    public static EmulatorEnv createBundled() {
        return new EmulatorEnv();
    }

    private EmulatorEnv() {
    }

    @Override
    void start() throws Exception {
        String overridePath = System.getProperty(EMULATOR_OVERRIDE_PROPERTY_NAME);
        this.emulator = !Strings.isNullOrEmpty((String)overridePath) ? Emulator.createFromPath((Path)Paths.get(overridePath, new String[0])) : Emulator.createBundled();
        this.emulator.start();
        this.dataSettings = BigtableDataSettings.newBuilderForEmulator((int)this.emulator.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).build();
        this.dataClient = BigtableDataClient.create((BigtableDataSettings)this.dataSettings);
        this.tableAdminSettings = BigtableTableAdminSettings.newBuilderForEmulator((int)this.emulator.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).build();
        this.tableAdminClient = BigtableTableAdminClient.create((BigtableTableAdminSettings)this.tableAdminSettings);
        this.tableAdminClient.createTable(CreateTableRequest.of((String)TABLE_ID).addFamily(this.getFamilyId()));
    }

    @Override
    void stop() {
        this.tableAdminClient.close();
        this.dataClient.close();
        this.emulator.stop();
    }

    @Override
    public BigtableDataSettings getDataClientSettings() {
        return this.dataSettings;
    }

    @Override
    public BigtableInstanceAdminSettings getInstanceAdminClientSettings() {
        throw new UnsupportedOperationException("instance admin is not support by the emulator");
    }

    @Override
    public BigtableTableAdminSettings getTableAdminSettings() {
        return this.tableAdminSettings;
    }

    @Override
    public String getProjectId() {
        return PROJECT_ID;
    }

    @Override
    public String getInstanceId() {
        return INSTANCE_ID;
    }

    @Override
    public String getTableId() {
        return TABLE_ID;
    }

    @Override
    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    @Override
    public BigtableDataClient getDataClientForInstance(String instanceId) throws IOException {
        throw new UnsupportedOperationException("Could not create a data client for another instance.");
    }

    @Override
    public BigtableTableAdminClient getTableAdminClient() {
        return this.tableAdminClient;
    }

    @Override
    public BigtableTableAdminClient getTableAdminClientForInstance(String instanceId) throws IOException {
        throw new UnsupportedOperationException("Could not create a table admin for another instance.");
    }

    @Override
    public BigtableInstanceAdminClient getInstanceAdminClient() {
        throw new UnsupportedOperationException("InstanceAdminClient is not supported with emulator");
    }

    @Override
    public String getKmsKeyName() {
        throw new UnsupportedOperationException("CMEK is not supported with emulator");
    }

    @Override
    public boolean isInstanceAdminSupported() {
        return false;
    }
}

