/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.test_helpers.env;

import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.threeten.bp.Instant;

public class PrefixGenerator
implements TestRule {
    private static final Logger LOGGER = Logger.getLogger(TestEnvRule.class.getName());
    static final String PREFIX = "temp-";
    private static final AtomicInteger prefixCounter = new AtomicInteger(0);
    private static final int SUFFIX = new Random().nextInt(Integer.MAX_VALUE);
    private String testName;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PrefixGenerator.this.before(description);
                try {
                    base.evaluate();
                }
                finally {
                    PrefixGenerator.this.after();
                }
            }
        };
    }

    private void before(Description description) {
        this.testName = description.toString();
    }

    private void after() {
        this.testName = null;
    }

    public String newPrefix() {
        return PrefixGenerator.newPrefix(this.testName);
    }

    public static String newPrefix(String source) {
        String prefix = String.format("%s-%x-%x", PrefixGenerator.newTimePrefix(Instant.now()), SUFFIX, prefixCounter.getAndIncrement());
        LOGGER.info(source + ": newPrefix: " + prefix);
        return prefix;
    }

    static String newTimePrefix(Instant instant) {
        return String.format("temp-08%x", instant.getEpochSecond());
    }
}

