/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.test_helpers.env;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.cloud.bigtable.admin.v2.models.Instance;
import com.google.cloud.bigtable.test_helpers.env.AbstractTestEnv;
import com.google.cloud.bigtable.test_helpers.env.CloudEnv;
import com.google.cloud.bigtable.test_helpers.env.EmulatorEnv;
import com.google.cloud.bigtable.test_helpers.env.PrefixGenerator;
import cz.o2.proxima.internal.shaded.com.google.common.base.Joiner;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.internal.shaded.com.google.common.base.Strings;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import cz.o2.proxima.internal.shaded.com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

public class TestEnvRule
implements TestRule {
    private static final Logger LOGGER = Logger.getLogger(TestEnvRule.class.getName());
    private static final Boolean BIGTABLE_ENABLE_VERBOSE_GRPC_LOGS = Boolean.getBoolean("bigtable.enable-grpc-logs");
    private static final String BIGTABLE_GRPC_LOG_DIR = System.getProperty("bigtable.grpc-log-dir");
    private static final String BIGTABLE_EMULATOR_HOST_ENV_VAR = "BIGTABLE_EMULATOR_HOST";
    private static final String ENV_PROPERTY = "bigtable.env";
    private static final String env = System.getProperty("bigtable.env", "emulator");
    private AbstractTestEnv testEnv;
    private Handler grpcLogHandler;
    private static final Set<String> GRPC_LOGGER_NAMES = ImmutableSet.of((Object)"io.grpc", (Object)"cz.o2.proxima.beam.io.pubsub.io.grpc.netty.shaded");

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestEnvRule.this.before(description);
                try {
                    base.evaluate();
                }
                finally {
                    TestEnvRule.this.after();
                }
            }
        };
    }

    protected void before(Description description) throws Throwable {
        TruthJUnit.assume().withMessage("Integration tests can't run with the BIGTABLE_EMULATOR_HOST environment variable set. Please use the emulator-it maven profile instead").that(System.getenv()).doesNotContainKey((Object)BIGTABLE_EMULATOR_HOST_ENV_VAR);
        this.configureLogging(description);
        switch (env) {
            case "emulator": {
                this.testEnv = EmulatorEnv.createBundled();
                break;
            }
            case "cloud": {
                this.testEnv = CloudEnv.fromSystemProperties();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown env: %s. Please set the system property %s to either 'emulator' or 'cloud'.", env, ENV_PROPERTY));
            }
        }
        this.testEnv.start();
    }

    private void configureLogging(Description description) throws IOException {
        if (!BIGTABLE_ENABLE_VERBOSE_GRPC_LOGS.booleanValue()) {
            return;
        }
        Preconditions.checkState((!Strings.isNullOrEmpty((String)BIGTABLE_GRPC_LOG_DIR) ? 1 : 0) != 0, (Object)("The property " + BIGTABLE_GRPC_LOG_DIR + " must be set when verbose grpc logs are enabled"));
        Files.createDirectories(Paths.get(BIGTABLE_GRPC_LOG_DIR, new String[0]), new FileAttribute[0]);
        String basename = Joiner.on((String)"-").useForNull("").join((Object)description.getClassName(), (Object)description.getMethodName(), new Object[0]);
        Path logPath = Paths.get(BIGTABLE_GRPC_LOG_DIR, basename + ".log");
        this.grpcLogHandler = new FileHandler(logPath.toString());
        this.grpcLogHandler.setFormatter(new SimpleFormatter());
        this.grpcLogHandler.setLevel(Level.ALL);
        for (String grpcLoggerName : GRPC_LOGGER_NAMES) {
            Logger logger = Logger.getLogger(grpcLoggerName);
            logger.setLevel(Level.ALL);
            logger.addHandler(this.grpcLogHandler);
        }
    }

    private void after() {
        try {
            this.cleanUpStale();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to cleanup environment", e);
        }
        try {
            this.testEnv.stop();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to stop the environment", e);
        }
        this.testEnv = null;
        this.teardownLogging();
    }

    private void teardownLogging() {
        if (this.grpcLogHandler == null) {
            return;
        }
        for (String grpcLoggerName : GRPC_LOGGER_NAMES) {
            Logger.getLogger(grpcLoggerName).removeHandler(this.grpcLogHandler);
        }
        this.grpcLogHandler.flush();
        this.grpcLogHandler = null;
    }

    void cleanUpStale() throws ExecutionException, InterruptedException, IOException {
        String stalePrefix = PrefixGenerator.newTimePrefix(Instant.now().minus(1L, (TemporalUnit)ChronoUnit.DAYS));
        this.cleanupStaleTables(stalePrefix);
        if (this.env().isInstanceAdminSupported()) {
            this.cleanUpStaleAppProfile(stalePrefix);
            this.cleanUpStaleClusters(stalePrefix);
            this.cleanUpStaleInstances(stalePrefix);
        }
    }

    private void cleanupStaleTables(String stalePrefix) {
        for (String tableId : this.env().getTableAdminClient().listTables()) {
            if (!tableId.startsWith("temp-") || stalePrefix.compareTo(tableId) <= 0) continue;
            try {
                this.env().getTableAdminClient().deleteTable(tableId);
            }
            catch (NotFoundException notFoundException) {}
        }
    }

    private void cleanUpStaleAppProfile(String stalePrefix) {
        for (AppProfile appProfile : this.env().getInstanceAdminClient().listAppProfiles(this.env().getInstanceId())) {
            boolean isNewerThanStale;
            if (!appProfile.getId().startsWith("temp-")) continue;
            boolean bl = isNewerThanStale = appProfile.getId().compareTo(stalePrefix) > 0;
            if (isNewerThanStale) continue;
            try {
                this.env().getInstanceAdminClient().deleteAppProfile(this.env().getInstanceId(), appProfile.getId(), true);
            }
            catch (NotFoundException notFoundException) {}
        }
    }

    private void cleanUpStaleClusters(String stalePrefix) throws ExecutionException, InterruptedException {
        for (Cluster cluster : this.env().getInstanceAdminClient().listClusters(this.env().getInstanceId())) {
            boolean isNewerThanStale;
            if (!cluster.getId().startsWith("temp-")) continue;
            boolean bl = isNewerThanStale = cluster.getId().compareTo(stalePrefix) > 0;
            if (isNewerThanStale) continue;
            try {
                this.deleteBackups(this.env().getTableAdminClient(), cluster.getId());
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try {
                this.env().getInstanceAdminClient().deleteCluster(this.env().getInstanceId(), cluster.getId());
            }
            catch (NotFoundException notFoundException) {}
        }
    }

    private void cleanUpStaleInstances(String stalePrefix) throws IOException, ExecutionException, InterruptedException {
        for (Instance instance : this.env().getInstanceAdminClient().listInstances()) {
            boolean isNewerThanStale;
            if (!instance.getId().startsWith("temp-")) continue;
            boolean bl = isNewerThanStale = instance.getId().compareTo(stalePrefix) > 0;
            if (isNewerThanStale) continue;
            try {
                this.deleteInstance(instance.getId());
            }
            catch (NotFoundException notFoundException) {}
        }
    }

    private void deleteInstance(String instanceId) throws IOException, ExecutionException, InterruptedException {
        BigtableTableAdminSettings settings = this.env().getTableAdminSettings().toBuilder().setInstanceId(instanceId).build();
        try (BigtableTableAdminClient tableAdmin = BigtableTableAdminClient.create((BigtableTableAdminSettings)settings);){
            List clusters = this.env().getInstanceAdminClient().listClusters(instanceId);
            boolean isFirstCluster = true;
            for (Cluster cluster : clusters) {
                this.deleteBackups(tableAdmin, cluster.getId());
                if (!isFirstCluster) {
                    try {
                        this.env().getInstanceAdminClient().deleteCluster(instanceId, cluster.getId());
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
                isFirstCluster = false;
            }
        }
        try {
            this.env().getInstanceAdminClient().deleteInstance(instanceId);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void deleteBackups(BigtableTableAdminClient tableAdmin, String clusterId) throws ExecutionException, InterruptedException {
        ArrayList<ApiFuture> futures = new ArrayList<ApiFuture>();
        for (String backupId : tableAdmin.listBackups(clusterId)) {
            ApiFuture f = tableAdmin.deleteBackupAsync(clusterId, backupId);
            futures.add(f);
        }
        for (ApiFuture future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof NotFoundException) continue;
                throw e;
            }
        }
    }

    public AbstractTestEnv env() {
        return this.testEnv;
    }
}

