/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.grpc.BaseGrpcServiceException;
import cz.o2.proxima.beam.io.pubsub.io.grpc.Status;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BaseGrpcServiceExceptionTest {
    private static final String MESSAGE = "some message";
    private static final boolean NOT_RETRYABLE = false;
    private static final boolean IDEMPOTENT = true;

    @Test
    public void testBaseServiceException() {
        BaseGrpcServiceException serviceException = null;
        IOException exception = new SocketTimeoutException();
        serviceException = new BaseGrpcServiceException(exception, true);
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getMessage());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        Assert.assertNull((Object)serviceException.getReason());
        Assert.assertNull((Object)serviceException.getLocation());
        Assert.assertNull((Object)serviceException.getDebugInfo());
        exception = new SocketException();
        serviceException = new BaseGrpcServiceException(exception, true);
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getMessage());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        Assert.assertNull((Object)serviceException.getReason());
        Assert.assertNull((Object)serviceException.getLocation());
        Assert.assertNull((Object)serviceException.getDebugInfo());
        exception = new IOException("insufficient data written");
        serviceException = new BaseGrpcServiceException(exception, true);
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)"insufficient data written", (Object)serviceException.getMessage());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        Assert.assertNull((Object)serviceException.getReason());
        Assert.assertNull((Object)serviceException.getLocation());
        Assert.assertNull((Object)serviceException.getDebugInfo());
        IllegalArgumentException cause = new IllegalArgumentException("bad arg");
        InternalException apiException = new InternalException(MESSAGE, (Throwable)cause, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        serviceException = new BaseGrpcServiceException((ApiException)apiException);
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)apiException, (Object)serviceException.getCause());
        Assert.assertEquals((long)500L, (long)serviceException.getCode());
        Assert.assertEquals((Object)Status.Code.INTERNAL.name(), (Object)serviceException.getReason());
        Assert.assertNull((Object)serviceException.getLocation());
        Assert.assertNull((Object)serviceException.getDebugInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        SocketTimeoutException exception = new SocketTimeoutException();
        BaseGrpcServiceException cause = new BaseGrpcServiceException((IOException)exception, true);
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            BaseServiceException.translate((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)0L, (long)ex.getCode());
                Assert.assertNull((Object)ex.getMessage());
                Assert.assertTrue((boolean)ex.isRetryable());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }
}

