/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GrpcTransportOptions;
import java.util.concurrent.ScheduledExecutorService;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class GrpcTransportOptionsTest {
    private static final GrpcTransportOptions.ExecutorFactory MOCK_EXECUTOR_FACTORY = (GrpcTransportOptions.ExecutorFactory)EasyMock.createMock(GrpcTransportOptions.ExecutorFactory.class);
    private static final GrpcTransportOptions OPTIONS = GrpcTransportOptions.newBuilder().setExecutorFactory(MOCK_EXECUTOR_FACTORY).build();
    private static final GrpcTransportOptions DEFAULT_OPTIONS = GrpcTransportOptions.newBuilder().build();
    private static final GrpcTransportOptions OPTIONS_COPY = OPTIONS.toBuilder().build();

    @Test
    public void testBuilder() {
        Assert.assertSame((Object)MOCK_EXECUTOR_FACTORY, (Object)OPTIONS.getExecutorFactory());
        Assert.assertTrue((boolean)(DEFAULT_OPTIONS.getExecutorFactory() instanceof GrpcTransportOptions.DefaultExecutorFactory));
    }

    @Test
    public void testBaseEquals() {
        Assert.assertEquals((Object)OPTIONS, (Object)OPTIONS_COPY);
        Assert.assertNotEquals((Object)DEFAULT_OPTIONS, (Object)OPTIONS);
        GrpcTransportOptions options = OPTIONS.toBuilder().setExecutorFactory((GrpcTransportOptions.ExecutorFactory)new GrpcTransportOptions.DefaultExecutorFactory()).build();
        Assert.assertNotEquals((Object)OPTIONS, (Object)options);
    }

    @Test
    public void testBaseHashCode() {
        Assert.assertEquals((long)OPTIONS.hashCode(), (long)OPTIONS_COPY.hashCode());
        Assert.assertNotEquals((long)DEFAULT_OPTIONS.hashCode(), (long)OPTIONS.hashCode());
        GrpcTransportOptions options = OPTIONS.toBuilder().setExecutorFactory((GrpcTransportOptions.ExecutorFactory)new GrpcTransportOptions.DefaultExecutorFactory()).build();
        Assert.assertNotEquals((long)OPTIONS.hashCode(), (long)options.hashCode());
    }

    @Test
    public void testDefaultExecutorFactory() {
        GrpcTransportOptions.DefaultExecutorFactory executorFactory = new GrpcTransportOptions.DefaultExecutorFactory();
        ScheduledExecutorService executorService = (ScheduledExecutorService)executorFactory.get();
        Assert.assertSame((Object)executorService, (Object)executorFactory.get());
    }
}

